/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes.rework;

import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import java.util.HashMap;

public abstract class DataKey<T> {
    public final String key;

    public DataKey(String key) {
        this.key = key;
    }

    protected T get(HashMap<String, String> map) {
        String o;
        if (map.containsKey(this.key) && (o = map.get(this.key)) != null) {
            T finished = this.stringToObject(o);
            return finished;
        }
        return this.getEmpty();
    }

    public abstract T getEmpty();

    protected abstract T stringToObject(String var1);

    protected abstract String objectToString(T var1);

    public static class BooleanKey
    extends DataKey<Boolean> {
        public BooleanKey(String key) {
            super(key);
        }

        @Override
        public Boolean getEmpty() {
            return false;
        }

        @Override
        protected Boolean stringToObject(String o) {
            return Boolean.valueOf(o);
        }

        @Override
        protected String objectToString(Boolean o) {
            return o.toString();
        }
    }

    public static class FloatKey
    extends DataKey<Float> {
        public FloatKey(String key) {
            super(key);
        }

        @Override
        public Float getEmpty() {
            return Float.valueOf(0.0f);
        }

        @Override
        protected Float stringToObject(String o) {
            return Float.valueOf(o);
        }

        @Override
        protected String objectToString(Float o) {
            return o.toString();
        }
    }

    public static class IntKey
    extends DataKey<Integer> {
        public IntKey(String key) {
            super(key);
        }

        @Override
        public Integer getEmpty() {
            return 0;
        }

        @Override
        protected Integer stringToObject(String o) {
            return Integer.valueOf(o);
        }

        @Override
        protected String objectToString(Integer o) {
            return o.toString();
        }

        public void add(CustomItemData data, int amount) {
            int total = data.data.get(this) + amount;
            data.data.set(this, total);
        }
    }

    public static class StringKey
    extends DataKey<String> {
        public StringKey(String key) {
            super(key);
        }

        @Override
        public String getEmpty() {
            return "";
        }

        @Override
        protected String stringToObject(String o) {
            return o;
        }

        @Override
        protected String objectToString(String o) {
            return o;
        }
    }

    public static class RegistryKey<T extends ExileRegistry>
    extends DataKey<T> {
        ExileRegistryType type;

        public RegistryKey(String key, ExileRegistryType type) {
            super(key);
            this.type = type;
        }

        @Override
        public T getEmpty() {
            return (T)Database.getRegistry((ExileRegistryType)this.type).getDefault();
        }

        @Override
        protected T stringToObject(String o) {
            String id = o;
            ExileRegistry obj = Database.getRegistry((ExileRegistryType)this.type).get(id);
            try {
                return (T)obj;
            }
            catch (Exception e) {
                e.printStackTrace();
                return this.getEmpty();
            }
        }

        @Override
        protected String objectToString(T o) {
            return o.GUID();
        }
    }

    public static class EnumKey<T extends Enum>
    extends DataKey<T> {
        T empty;

        public EnumKey(T empty, String key) {
            super(key);
            this.empty = empty;
        }

        @Override
        public T getEmpty() {
            return this.empty;
        }

        @Override
        protected T stringToObject(String o) {
            try {
                Object tried = Enum.valueOf(this.empty.getClass(), o);
                return (T)tried;
            }
            catch (Exception e) {
                e.printStackTrace();
                return (T)this.getEmpty();
            }
        }

        @Override
        protected String objectToString(T o) {
            return ((Enum)o).name();
        }
    }
}

