/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.item_classes;

import com.robertx22.library_of_exile.deferred.RegObj;
import com.robertx22.library_of_exile.utils.ItemstackDataSaver;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.SlotFamily;
import com.robertx22.mine_and_slash.database.data.profession.PlayerUTIL;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.requirements.bases.GearRequestedFor;
import com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRequirement;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.TooltipContext;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.BaseStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearAffixesData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearInfusionData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.GearSocketsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.ImplicitStatsData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.UniqueStatsData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearTooltipUtils;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.SimpleStatCtx;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.ICommonDataItem;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class GearItemData
implements ICommonDataItem<GearRarity> {
    public BaseStatsData baseStats = new BaseStatsData();
    public ImplicitStatsData imp = new ImplicitStatsData();
    public GearAffixesData affixes = new GearAffixesData();
    public GearSocketsData sockets = new GearSocketsData();
    public UniqueStatsData uniqueStats;
    public GearInfusionData ench;
    public String rar = "common";
    public int lvl = 1;
    public String gtype = "";

    public int getQualityBaseStatsBonus(ExileStack stack) {
        return stack.get(StackKeys.CUSTOM).getOrCreate().data.get(CustomItemData.KEYS.QUALITY);
    }

    public int getTier() {
        return LevelUtils.levelToTier(this.lvl);
    }

    @Override
    public int getLevel() {
        return this.lvl;
    }

    @Override
    public ToggleAutoSalvageRarity.SalvageType getSalvageType() {
        if (this.GetBaseGearType().isWeapon()) {
            return ToggleAutoSalvageRarity.SalvageType.WEAPON;
        }
        if (this.GetBaseGearType().isArmor()) {
            return ToggleAutoSalvageRarity.SalvageType.ARMOR;
        }
        return ToggleAutoSalvageRarity.SalvageType.GEAR;
    }

    @Override
    public String getSalvageConfigurationId() {
        return this.GetBaseGearType().gear_slot;
    }

    public StatRequirement getRequirement() {
        return this.GetBaseGearType().req;
    }

    public boolean canPlayerWear(EntityData data) {
        if (PlayerUTIL.isFake((Player)data.getEntity())) {
            return true;
        }
        if (this.getLevel() > data.getLevel()) {
            return false;
        }
        return this.getRequirement().meetsReq(this.getLevel(), data);
    }

    public boolean isValidItem() {
        return ExileDB.GearTypes().isRegistered(this.gtype);
    }

    public int getEmptySockets() {
        return this.sockets.getTotalSockets() - this.sockets.getSocketedGemsCount();
    }

    public boolean canGetAffix(Affix affix) {
        if (affix.only_one_per_item && this.affixes.containsAffix(affix)) {
            return false;
        }
        if (!affix.one_of_a_kind.isEmpty() && this.affixes.getPrefixesAndSuffixes().stream().anyMatch(x -> x.getAffix().one_of_a_kind.equals(affix.one_of_a_kind))) {
            return false;
        }
        return affix.meetsRequirements(new GearRequestedFor(this));
    }

    @Override
    public String getRarityId() {
        return this.rar;
    }

    @Override
    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public Component name(ItemStack stack) {
        return stack.m_41786_();
    }

    public BaseGearType GetBaseGearType() {
        return (BaseGearType)ExileDB.GearTypes().get(this.gtype);
    }

    public List<MutableComponent> GetDisplayName(ExileStack stack) {
        try {
            return this.getFullAffixedName(stack);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Arrays.asList(new MutableComponent[0]);
        }
    }

    private MutableComponent prefixChecker(ExileStack stack) {
        if (this.affixes.hasPrefix()) {
            AffixData prefix = this.affixes.pre.stream().sorted(Comparator.comparingInt(x -> -x.p.intValue())).findFirst().get();
            return prefix.BaseAffix().locName();
        }
        return Component.m_237113_((String)"");
    }

    private MutableComponent uniqueChecker(ExileStack stack) {
        MutableComponent base = this.GetBaseGearType().locName();
        if (this.imp.has()) {
            base = this.imp.get().locName();
        }
        if (this.uniqueStats == null) {
            return base;
        }
        UniqueGear uniq = this.uniqueStats.getUnique(stack);
        if (uniq.replaces_name) {
            return uniq.locName().m_130940_(this.getRarity().textFormatting());
        }
        return Formatter.UNIQUE_NAME_FORMAT.locName(this.uniqueStats.getUnique(stack).locName(), base).m_130940_(this.getRarity().textFormatting());
    }

    private MutableComponent suffixChecker(ExileStack stack) {
        if (this.affixes.hasSuffix()) {
            AffixData suffix = this.affixes.suf.stream().sorted(Comparator.comparingInt(x -> -x.p.intValue())).findFirst().get();
            return suffix.BaseAffix().locName();
        }
        return Component.m_237113_((String)"");
    }

    private List<MutableComponent> getFullAffixedName(ExileStack stack) {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        ChatFormatting format = this.getRarity().textFormatting();
        String str1 = this.prefixChecker(stack).getString();
        String str2 = this.uniqueChecker(stack).getString();
        String str3 = this.suffixChecker(stack).getString();
        MutableComponent text = !str1.isEmpty() && !str2.isEmpty() && !str3.isEmpty() ? Formatter.GEAR_ITEM_NAME_ALL.locName(this.prefixChecker(stack), this.uniqueChecker(stack), this.suffixChecker(stack)) : (str1.isEmpty() && !str2.isEmpty() && str3.isEmpty() ? Formatter.GEAR_ITEM_NAME_ONLY_GEAR.locName(this.uniqueChecker(stack)) : (!str1.isEmpty() && !str2.isEmpty() && str3.isEmpty() ? Formatter.GEAR_ITEM_NAME_PRE_GEAR.locName(this.prefixChecker(stack), this.uniqueChecker(stack)) : Formatter.GEAR_ITEM_NAME_ANOTHER.locName(this.prefixChecker(stack), this.uniqueChecker(stack), this.suffixChecker(stack))));
        text.m_130940_(format);
        list.addAll(TooltipUtils.cutIfTooLong(text, format));
        return list;
    }

    public List<IStatsContainer> GetAllStatContainers() {
        ArrayList<IStatsContainer> list = new ArrayList<IStatsContainer>();
        this.IfNotNullAdd(this.baseStats, list);
        this.IfNotNullAdd(this.imp, list);
        this.affixes.getAllAffixesAndSockets().forEach(x -> this.IfNotNullAdd(x, list));
        this.IfNotNullAdd(this.sockets, list);
        this.IfNotNullAdd(this.uniqueStats, list);
        this.IfNotNullAdd(this.ench, list);
        return list;
    }

    public List<IStatsContainer> GetAllStatContainersExceptBase() {
        return this.GetAllStatContainers().stream().filter(x -> !(x instanceof BaseStatsData)).collect(Collectors.toList());
    }

    public List<MutableComponent> getEnchantCompatTooltip(ItemStack stack) {
        StatContext ench = this.getEnchantCompatStats(stack);
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        if (ench == null) {
            return list;
        }
        list.add(Words.EnchantCompatStats.locName().m_130940_(ChatFormatting.AQUA));
        for (ExactStatData stat : ench.stats) {
            list.addAll(stat.GetTooltipString());
        }
        return list;
    }

    public StatContext getEnchantCompatStats(ItemStack stack) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (Map.Entry en : stack.getAllEnchantments().entrySet()) {
            String id = ForgeRegistries.ENCHANTMENTS.getKey((Object)((Enchantment)en.getKey())).toString();
            for (StatCompat compat : ExileDB.StatCompat().getFilterWrapped((Predicate<StatCompat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getEnchantCompatStats$5(java.lang.String com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat ), (Lcom/robertx22/mine_and_slash/database/data/stat_compat/StatCompat;)Z)((String)id)).list) {
                ExactStatData result = compat.getEnchantCompatResult(Arrays.asList(stack), this.lvl);
                if (result == null) continue;
                list.add(result);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        SimpleStatCtx ctx = new SimpleStatCtx(StatContext.StatCtxType.ENCHANT_COMPAT, list);
        return ctx;
    }

    public static StatContext getEnchantCompatStats(Player p, List<GearData> gears) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        HashSet enchants = new HashSet();
        for (GearData gear : gears) {
            enchants.addAll(gear.stack.getAllEnchantments().keySet());
        }
        int lvl = Load.Unit((Entity)p).getLevel();
        List<ItemStack> stacks = gears.stream().map(x -> x.stack).collect(Collectors.toList());
        for (Enchantment enchant : enchants) {
            String id = ForgeRegistries.ENCHANTMENTS.getKey((Object)enchant).toString();
            for (StatCompat compat : ExileDB.StatCompat().getFilterWrapped((Predicate<StatCompat>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getEnchantCompatStats$7(java.lang.String com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat ), (Lcom/robertx22/mine_and_slash/database/data/stat_compat/StatCompat;)Z)((String)id)).list) {
                ExactStatData result = compat.getEnchantCompatResult(stacks, lvl);
                if (result == null) continue;
                list.add(result);
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        SimpleStatCtx ctx = new SimpleStatCtx(StatContext.StatCtxType.ENCHANT_COMPAT, list);
        return ctx;
    }

    public List<ExactStatData> GetAllStats(ExileStack stack) {
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        for (IStatsContainer x : this.GetAllStatContainers()) {
            List<ExactStatData> stats = x.GetAllStats(stack);
            stats.forEach(s -> list.add((ExactStatData)s));
        }
        return list;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void BuildTooltip(TooltipContext ctx) {
        GearTooltipUtils.BuildTooltip(this, ctx.stack, ctx.tooltip, ctx.data);
    }

    private <T> void IfNotNullAdd(T obj, List<T> list) {
        if (obj != null) {
            list.add(obj);
        }
    }

    @Override
    public List<ItemStack> getSalvageResult(ExileStack stack) {
        if (!stack.get(StackKeys.CUSTOM).getOrCreate().data.get(CustomItemData.KEYS.SALVAGING_DISABLED).booleanValue()) {
            if (this.isUnique()) {
                return Arrays.asList(new ItemStack((ItemLike)((RegObj)RandomUtils.randomFromList(RarityItems.RARITY_STONE.values().stream().toList())).get(), RandomUtils.RandomRange((int)2, (int)9)));
            }
            int amount = 1;
            return Arrays.asList(new ItemStack((ItemLike)RarityItems.RARITY_STONE.getOrDefault(this.getRarity().GUID(), RarityItems.RARITY_STONE.get("common")).get(), amount));
        }
        return Arrays.asList(ItemStack.f_41583_);
    }

    @Override
    public ItemstackDataSaver<GearItemData> getStackSaver() {
        return StackSaving.GEARS;
    }

    @Override
    public void saveToStack(ItemStack stack) {
        this.getStackSaver().saveTo(stack, (Object)this);
    }

    public boolean isWeapon() {
        try {
            if (this.GetBaseGearType().family().equals((Object)SlotFamily.Weapon)) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static /* synthetic */ boolean lambda$getEnchantCompatStats$7(String id, StatCompat x) {
        return x.isEnchantCompat() && x.enchant_id.equals(id);
    }

    private static /* synthetic */ boolean lambda$getEnchantCompatStats$5(String id, StatCompat x) {
        return x.isEnchantCompat() && x.enchant_id.equals(id);
    }
}

