/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts;

import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPart;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IGearPartTooltip;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IRerollable;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.IStatsContainer;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;

public class UniqueStatsData
implements IGearPartTooltip,
IRerollable,
IStatsContainer {
    public List<Integer> perc = new ArrayList<Integer>();
    public static int MAX_STATS = 10;

    @Override
    public void RerollFully(GearItemData gear) {
        this.RerollNumbers(gear);
    }

    @Override
    public void RerollNumbers(GearItemData gear) {
        this.perc.clear();
        for (int i = 0; i < MAX_STATS; ++i) {
            this.perc.add(this.getMinMax(gear).random());
        }
    }

    public void increaseAllBy(GearItemData gear, int add) {
        int max = this.getMinMax((GearItemData)gear).max;
        for (int i = 0; i < this.perc.size(); ++i) {
            int num = MathHelper.clamp(this.perc.get(i) + add, 0, max);
            this.perc.set(i, num);
        }
    }

    @Override
    public List<Component> GetTooltipString(StatRangeInfo info, ExileStack stack) {
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Itemtips.UNIQUE_STATS.locName().m_130940_(ChatFormatting.YELLOW));
        this.getAllStatsWithCtx(stack, new StatRangeInfo(ModRange.of(new MinMax(0, 100)))).forEach(x -> list.addAll(x.GetTooltipString()));
        return list;
    }

    @Override
    public MinMax getMinMax(GearItemData gear) {
        return new MinMax(0, 100);
    }

    public UniqueGear getUnique(ExileStack stack) {
        return (UniqueGear)ExileDB.UniqueGears().get(stack.get(StackKeys.CUSTOM).getOrCreate().data.get(CustomItemData.KEYS.UNIQUE_ID));
    }

    @Override
    public IGearPart.Part getPart() {
        return IGearPart.Part.UNIQUE_STATS;
    }

    public List<TooltipStatWithContext> getAllStatsWithCtx(ExileStack stack, StatRangeInfo info) {
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        ArrayList<TooltipStatWithContext> list = new ArrayList<TooltipStatWithContext>();
        int i = 0;
        for (StatMod mod : this.getUnique(stack).uniqueStats()) {
            ExactStatData exact = mod.ToExactStat(this.perc.get(i), gear.getLevel());
            list.add(new TooltipStatWithContext(new TooltipStatInfo(exact, this.perc.get(i), info), mod, gear.getLevel()));
            ++i;
        }
        return list;
    }

    @Override
    public List<ExactStatData> GetAllStats(ExileStack stack) {
        GearItemData gear = stack.get(StackKeys.GEAR).get();
        ArrayList<ExactStatData> list = new ArrayList<ExactStatData>();
        try {
            int i = 0;
            for (StatMod mod : this.getUnique(stack).uniqueStats()) {
                list.add(mod.ToExactStat(this.perc.get(i), gear.getLevel()));
                ++i;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

