/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.prophecy;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.FilterListWrap;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifier;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifierType;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyStart;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.prophecy.ProphecyData;
import com.robertx22.mine_and_slash.prophecy.ProphecyModifierData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.world.entity.player.Player;

public class ProphecyGeneration {
    public static ProphecyData generate(Player p) {
        MapData map = Load.mapAt(p.m_9236_(), p.m_20183_());
        int lvl = map.map.lvl;
        int tier = map.map.tier;
        float cost = 10.0f;
        List<ProphecyModifierType> modtypes = Arrays.stream(ProphecyModifierType.values()).toList();
        ProphecyData data = new ProphecyData();
        data.uuid = UUID.randomUUID().toString();
        data.amount = RandomUtils.RandomRange((int)1, (int)3);
        cost *= (float)data.amount;
        ProphecyStart start = (ProphecyStart)ExileDB.ProphecyStarts().random();
        data.start = start.GUID();
        ItemBlueprint b = start.create(lvl, tier);
        try {
            for (ProphecyModifierType type : modtypes) {
                if (!start.acceptsModifier(type) || !type.canApplyTo(start, b) || !RandomUtils.roll((float)type.chanceToSpawn())) continue;
                FilterListWrap possible = ExileDB.ProphecyModifiers().getFilterWrapped(x -> x.modifier_type == type).of(x -> {
                    if (x.tier_req > tier) {
                        return false;
                    }
                    return x.lvl_req <= lvl;
                });
                if (!possible.list.isEmpty()) {
                    ProphecyModifier mod = (ProphecyModifier)possible.random();
                    if (mod == null) continue;
                    ProphecyModifierData md = new ProphecyModifierData(mod.GUID());
                    data.mods.add(md);
                    cost *= mod.cost_multi;
                    continue;
                }
                ExileLog.get().warn(type.name() + " prophecy type  of start " + start.GUID() + " has no modifiers for tier/lvl" + tier + "," + lvl, new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        data.cost = (int)cost;
        return data;
    }
}

