/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.prophecy;

import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyStart;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.prophecy.PlayerProphecies;
import com.robertx22.mine_and_slash.prophecy.ProphecyModifierData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ProphecyData {
    public String uuid = "";
    public String start = "";
    public int amount = 1;
    public int cost = 0;
    public List<ProphecyModifierData> mods = new ArrayList<ProphecyModifierData>();

    public List<ItemStack> generateRewards(Player p) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        PlayerProphecies data = Load.player((Player)p).prophecy;
        MapData map = Load.mapAt(p.m_9236_(), p.m_20183_());
        int lvl = map.map.lvl;
        int tier = map.map.tier;
        for (int i = 0; i < this.amount; ++i) {
            ItemBlueprint blueprint = this.getStart().create(lvl, tier);
            for (ProphecyModifierData mod : this.mods) {
                mod.get().modifier_type.set(blueprint, mod.get().data);
            }
            ItemStack stack = blueprint.createStack();
            list.add(stack);
        }
        return list;
    }

    public List<MutableComponent> getTooltip() {
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        ProphecyStart start = this.getStart();
        list.add(start.locName().m_130940_(ChatFormatting.LIGHT_PURPLE));
        list.add(Component.m_237113_((String)""));
        for (ProphecyModifierData mod : this.mods) {
            list.add(mod.get().modifier_type.getTooltip(mod.get().data));
        }
        list.add(Words.X_ITEMS.locName(this.amount));
        list.add(Words.COSTS_FAVOR.locName(this.cost));
        return list;
    }

    public ProphecyStart getStart() {
        return (ProphecyStart)ExileDB.ProphecyStarts().get(this.start);
    }
}

