/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.mixin_methods;

import com.robertx22.addons.orbs_of_crafting.currency.IItemAsCurrency;
import com.robertx22.addons.orbs_of_crafting.currency.base.CodeCurrency;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.auto_item.AutoItem;
import com.robertx22.mine_and_slash.database.data.profession.items.CraftedSoulItem;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.mmorpg.ForgeEvents;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.SlashItems;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.jewel.JewelItemData;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.SavedGearSoul;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.StatSoulData;
import com.robertx22.mine_and_slash.saveclasses.stat_soul.StatSoulItem;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import com.robertx22.mine_and_slash.vanilla_mc.items.SoulExtractorItem;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.RarityStoneItem;
import com.robertx22.orbs_of_crafting.misc.LocReqContext;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.ItemStackedOnOtherEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class OnItemInteract {
    static List<ClickFeature> CLICKS = new ArrayList<ClickFeature>();

    public static void register() {
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (StackSaving.JEWEL.has(craftedStack)) {
                    ItemStack cost;
                    JewelItemData data = (JewelItemData)StackSaving.JEWEL.loadFrom(craftedStack);
                    if (data.uniq.isCraftableUnique() && (cost = data.uniq.getStackNeededForUpgrade()).m_41720_() == currency.m_41720_() && currency.m_41613_() >= cost.m_41613_() && data.uniq.getCraftedTier().canUpgradeMore()) {
                        data.uniq.upgradeUnique(data);
                        StackSaving.JEWEL.saveTo(craftedStack, (Object)data);
                        currency.m_41774_(cost.m_41613_());
                        return new Result(true).ding();
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (craftedStack.m_41768_() && currency.m_41720_() instanceof RarityStoneItem) {
                    if (!StackSaving.GEARS.has(craftedStack) && !StackSaving.OMEN.has(craftedStack)) {
                        player.m_213846_((Component)Chats.NOT_GEAR_OR_LACKS_SOUL.locName().m_130940_(ChatFormatting.RED));
                        return new Result(false);
                    }
                    RarityStoneItem essence = (RarityStoneItem)currency.m_41720_();
                    SoundUtils.playSound((Entity)player, (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
                    int repair = essence.getTotalRepair();
                    craftedStack.m_41721_(craftedStack.m_41773_() - repair);
                    currency.m_41774_(1);
                    return new Result(true).ding();
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (currency.m_41720_() instanceof StatSoulItem || currency.m_41720_() instanceof CraftedSoulItem) {
                    StatSoulData data = (StatSoulData)StackSaving.STAT_SOULS.loadFrom(currency);
                    Item item = currency.m_41720_();
                    if (item instanceof CraftedSoulItem) {
                        CraftedSoulItem cs = (CraftedSoulItem)item;
                        data = cs.getSoul(currency);
                    }
                    if (data != null) {
                        ExplainedResult res = data.canInsertIntoStack(craftedStack);
                        if (res.can) {
                            if (craftedStack.m_41613_() == 1) {
                                ItemStack result = data.insertAsUnidentifiedOn(craftedStack, player);
                                craftedStack.m_41774_(1);
                                slot.m_5852_(result);
                                currency.m_41774_(1);
                                return new Result(true).ding();
                            }
                        } else if (res.answer != null) {
                            player.m_213846_(res.answer);
                        }
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                if (currency.m_41720_() instanceof IItemAsCurrency) {
                    Item item;
                    LocReqContext ctx = new LocReqContext(player, craftedStack, currency);
                    if (!craftedStack.m_41619_() && (item = ctx.Currency.m_41720_()) instanceof IItemAsCurrency) {
                        IItemAsCurrency c = (IItemAsCurrency)item;
                        CodeCurrency effect = c.currencyEffect(ctx.Currency);
                        ExplainedResult can = effect.canItemBeModified(ctx);
                        if (can.can) {
                            ItemStack result = effect.modifyItem((LocReqContext)ctx).stack.m_41777_();
                            craftedStack.m_41774_(1);
                            currency.m_41774_(1);
                            slot.m_5852_(result);
                            return new Result(true);
                        }
                        player.m_213846_(can.answer);
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                Item item = currency.m_41720_();
                if (item instanceof SoulExtractorItem) {
                    SoulExtractorItem se = (SoulExtractorItem)item;
                    GearItemData gear = (GearItemData)StackSaving.GEARS.loadFrom(craftedStack);
                    if (gear != null) {
                        try {
                            if (se.canExtract(gear.getRarity())) {
                                StatSoulData soul = new StatSoulData();
                                soul.slot = gear.GetBaseGearType().getGearSlot().GUID();
                                ExileStack ex = ExileStack.of(craftedStack);
                                soul.rar = gear.rar;
                                soul.gear = new SavedGearSoul(ex.get(StackKeys.GEAR).get(), ex.get(StackKeys.POTENTIAL).getOrCreate(), ex.get(StackKeys.CUSTOM).getOrCreate());
                                ItemStack soulstack = soul.toStack();
                                SoundUtils.playSound((Entity)player, (SoundEvent)SoundEvents.f_11871_);
                                craftedStack.m_41774_(1);
                                currency.m_41774_(1);
                                PlayerUtils.giveItem(soulstack, player);
                                return new Result(true).ding();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                return new Result(false);
            }
        });
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                GearItemData gear;
                if (currency.m_150930_((Item)SlashItems.SOUL_CLEANER.get()) && (gear = (GearItemData)StackSaving.GEARS.loadFrom(craftedStack)) != null && !ServerContainer.get().isSoulCleanBanned(craftedStack.m_41720_())) {
                    try {
                        craftedStack.m_41784_().m_128473_(StackSaving.GEARS.GUID());
                        currency.m_41774_(1);
                        return new Result(true).ding();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return new Result(false);
            }
        });
        ForgeEvents.registerForgeEvent(ItemStackedOnOtherEvent.class, x -> {
            Player player = x.getPlayer();
            if (player.m_9236_().f_46443_) {
                return;
            }
            if (x.getClickAction() != ClickAction.SECONDARY) {
                // empty if block
            }
            ItemStack currency = x.getStackedOnItem();
            ItemStack craftedStack = x.getCarriedItem();
            for (ClickFeature click : CLICKS) {
                Result result = click.tryApply(player, craftedStack, currency, x.getSlot());
                if (result.doDing) {
                    SoundUtils.ding((Level)player.m_9236_(), (BlockPos)player.m_20183_());
                    SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
                }
                if (!result.can) continue;
                x.setCanceled(true);
                break;
            }
        });
        ForgeEvents.registerForgeEvent(PlayerEvent.ItemCraftedEvent.class, x -> {
            try {
                if (!x.getEntity().m_9236_().f_46443_) {
                    ItemStack stack = x.getCrafting();
                    AutoItem.tryInsertTo(stack, x.getEntity());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        ForgeEvents.registerForgeEvent(EntityItemPickupEvent.class, x -> {
            try {
                if (!x.getEntity().m_9236_().f_46443_) {
                    ItemStack stack = x.getItem().m_32055_();
                    AutoItem.tryInsertTo(stack, x.getEntity());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private static abstract class ClickFeature {
        private ClickFeature() {
        }

        public abstract Result tryApply(Player var1, ItemStack var2, ItemStack var3, Slot var4);
    }

    private static class Result {
        public boolean can;
        private boolean doDing = false;

        public Result(boolean can) {
            this.can = can;
        }

        public Result ding() {
            this.doDing = true;
            return this;
        }
    }
}

