/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints.bases;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.loot.blueprints.ItemBlueprint;

public abstract class BlueprintPart<T, C extends ItemBlueprint> {
    private T part;
    protected C blueprint;
    public boolean canBeNull = false;

    public BlueprintPart(C blueprint) {
        this.blueprint = blueprint;
    }

    protected abstract T generateIfNull();

    public void set(T t) {
        if (this.part == null) {
            this.part = t;
        } else {
            ExileLog.get().warn("Do not override an already set and created part!", new Object[0]);
        }
    }

    public void override(T t) {
        this.part = t;
    }

    public boolean isGenerated() {
        return this.part != null;
    }

    public T get() {
        if (this.part == null) {
            this.part = this.generateIfNull();
        }
        if (!this.canBeNull && this.part == null) {
            ExileLog.get().warn("Item is null even after being generated!", new Object[0]);
        }
        return this.part;
    }
}

