/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.database.data.aura.AuraGem;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.ITypeBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.bases.RegistryPart;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import net.minecraft.world.item.ItemStack;

public class SkillGemBlueprint
extends RarityItemBlueprint
implements ITypeBlueprint {
    RegistryPart<SupportGem> SUPP = new RegistryPart<SupportGem>(this, ExileRegistryTypes.SUPPORT_GEM, x -> this.info.level >= x.min_lvl);
    RegistryPart<AuraGem> AURA = new RegistryPart<AuraGem>(this, ExileRegistryTypes.AURA, x -> this.info.level >= x.min_lvl);
    RegistryPart<Spell> SPELL = new RegistryPart<Spell>(this, ExileRegistryTypes.SPELL, x -> this.info.level >= x.min_lvl);
    SkillGemData.SkillGemType type;

    public SkillGemBlueprint(LootInfo info, SkillGemData.SkillGemType type) {
        super(info);
        this.rarity.setupChances(info);
        this.type = type;
    }

    public SkillGemData createData() {
        GearRarity rar = (GearRarity)this.rarity.get();
        String id = ((ExileRegistry)this.getType().get()).GUID();
        SkillGemData data = new SkillGemData();
        data.id = id;
        data.type = this.type;
        data.rar = rar.GUID();
        data.perc = rar.stat_percents.random();
        return data;
    }

    @Override
    protected ItemStack generate() {
        SkillGemData data = this.createData();
        ItemStack stack = data.getItem().m_7968_();
        StackSaving.SKILL_GEM.saveTo(stack, (Object)data);
        return stack;
    }

    public RegistryPart<? extends ExileRegistry> getType() {
        if (this.type == SkillGemData.SkillGemType.AURA) {
            return this.AURA;
        }
        if (this.type == SkillGemData.SkillGemType.SUPPORT) {
            return this.SUPP;
        }
        if (this.type == SkillGemData.SkillGemType.SKILL) {
            return this.SPELL;
        }
        return null;
    }

    @Override
    public void setType(String type) {
        this.getType().set(type);
    }
}

