/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.dungeon_realm.item.DungeonMapGenSettings;
import com.robertx22.dungeon_realm.item.DungeonMapItem;
import com.robertx22.mine_and_slash.database.data.map_affix.MapAffix;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.RarityItemBlueprint;
import com.robertx22.mine_and_slash.maps.MapAffixData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import java.util.ArrayList;
import net.minecraft.world.item.ItemStack;

public class MapBlueprint
extends RarityItemBlueprint {
    boolean uberMap = false;

    public MapBlueprint(LootInfo info) {
        super(info);
    }

    @Override
    public ItemStack generate() {
        return DungeonMapItem.newRandomMapItemStack((DungeonMapGenSettings)new DungeonMapGenSettings());
    }

    public MapItemData createData() {
        MapItemData data = new MapItemData();
        GearRarity rarity = (GearRarity)this.rarity.get();
        data.rar = rarity.GUID();
        data.tier = rarity.getPossibleMapTiers().random();
        MapBlueprint.genAffixes(data, rarity);
        return data;
    }

    public static void genAffixes(MapItemData map, GearRarity rarity) {
        map.affixes = new ArrayList<MapAffixData>();
        int amount = rarity.getAffixAmount();
        ArrayList<String> affixes = new ArrayList<String>();
        for (int i = 0; i < amount; ++i) {
            MapAffix affix = (MapAffix)ExileDB.MapAffixes().getFilterWrapped(x -> x.req.isEmpty()).random();
            while (affixes.contains(affix.GUID())) {
                affix = (MapAffix)ExileDB.MapAffixes().getFilterWrapped(x -> x.req.isEmpty()).random();
            }
            int percent = rarity.stat_percents.random();
            map.affixes.add(new MapAffixData(affix, percent));
            affixes.add(affix.GUID());
        }
    }
}

