/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.loot.blueprints;

import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.bases.LevelPart;
import net.minecraft.world.item.ItemStack;

public abstract class ItemBlueprint {
    public LootInfo info = null;
    boolean itemWasGenerated = false;
    public LevelPart level = new LevelPart(this);

    public ItemBlueprint(LootInfo info) {
        this.info = info;
        this.level.number = info.level;
        this.onConstruct();
    }

    void onConstruct() {
    }

    protected abstract ItemStack generate();

    public final ItemStack createStack() {
        this.checkAndSetGeneratedBoolean();
        ItemStack stack = this.generate();
        return stack;
    }

    private void checkAndSetGeneratedBoolean() {
        if (this.itemWasGenerated) {
            try {
                throw new Exception("Do not use a blueprint instance to make more than 1 item!");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            this.itemWasGenerated = true;
        }
    }
}

