/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.wiki.reworked.filters;

import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.league.League;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryEntry;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryGroup;
import com.robertx22.mine_and_slash.gui.wiki.reworked.NewWikiScreen;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.GroupFilterEntry;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.AffixForBaseGearFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.CurrencyLeagueFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.RarityFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.RunewordSlotFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.SpellTagFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.UniqueLeagueFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.UniqueSlotFilter;
import com.robertx22.mine_and_slash.tags.imp.SpellTag;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public class GroupFilterType {
    public static List<GroupFilterType> ALL = new ArrayList<GroupFilterType>();
    public static GroupFilterType AFFIX_SLOTS = new GroupFilterType(BestiaryGroup.AFFIX, Words.ON_SLOTS, () -> ExileDB.GearTypes().getList().stream().map(x -> new AffixForBaseGearFilter((BaseGearType)x)).collect(Collectors.toList()));
    public static GroupFilterType UNIQUE_SLOTS = new GroupFilterType(BestiaryGroup.UNIQUE_GEAR, Words.ON_SLOTS, () -> ExileDB.GearSlots().getList().stream().map(x -> new UniqueSlotFilter((GearSlot)x)).collect(Collectors.toList()));
    public static GroupFilterType UNIQUE_LEAGUES = new GroupFilterType(BestiaryGroup.UNIQUE_GEAR, Words.LEAGUE, () -> LibDatabase.Leagues().getList().stream().map(x -> new UniqueLeagueFilter((League)x)).collect(Collectors.toList()));
    public static GroupFilterType CURRENCY_LEAGUES = new GroupFilterType(BestiaryGroup.CURRENCY, Words.LEAGUE, () -> LibDatabase.Leagues().getList().stream().map(x -> new CurrencyLeagueFilter((League)x)).collect(Collectors.toList()));
    public static GroupFilterType RUNEWORD_SLOTS = new GroupFilterType(BestiaryGroup.RUNEWORD, Words.ON_SLOTS, () -> ExileDB.GearSlots().getList().stream().map(x -> new RunewordSlotFilter((GearSlot)x)).collect(Collectors.toList()));
    public static GroupFilterType SPELL_TAGS = new GroupFilterType(BestiaryGroup.SPELL, Words.TAGS, () -> SpellTag.getAll().stream().map(x -> new SpellTagFilter((SpellTag)x)).collect(Collectors.toList()));
    public BestiaryGroup forGroup;
    public Words word;
    public Supplier<List<GroupFilterEntry>> entries;

    public static void init() {
        GroupFilterType.forGroups(Words.RARITIES, () -> ExileDB.GearRarities().getList().stream().map(x -> new RarityFilter((GearRarity)x)).collect(Collectors.toList()), BestiaryGroup.GEM, BestiaryGroup.CURRENCY);
    }

    static void forGroups(Words word, Supplier<List<GroupFilterEntry>> entries, BestiaryGroup ... groups) {
        for (BestiaryGroup group : groups) {
            new GroupFilterType(group, word, entries);
        }
    }

    public List<GroupFilterEntry> getEntriesWithAtLeastOneResult(NewWikiScreen screen) {
        return this.entries.get().stream().filter(x -> screen.group.getAll(1).stream().anyMatch(e -> x.isValid((BestiaryEntry)e))).collect(Collectors.toList());
    }

    public GroupFilterType(BestiaryGroup forGroup, Words word, Supplier<List<GroupFilterEntry>> entries) {
        this.forGroup = forGroup;
        this.word = word;
        this.entries = entries;
        ALL.add(this);
    }

    static {
        GroupFilterType.init();
    }
}

