/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.wiki;

import com.robertx22.addons.orbs_of_crafting.currency.base.CodeCurrency;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.aura.AuraGem;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.gems.Gem;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.runes.Rune;
import com.robertx22.mine_and_slash.database.data.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.gui.wiki.BestiaryEntry;
import com.robertx22.mine_and_slash.gui.wiki.all.DBItemEntry;
import com.robertx22.mine_and_slash.gui.wiki.all.ProfExpBestiary;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.GroupFilterEntry;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.GroupFilterType;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.AffixTypeFilter;
import com.robertx22.mine_and_slash.gui.wiki.reworked.filters.all.RunewordRunesCountFilter;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.GearBlueprint;
import com.robertx22.mine_and_slash.loot.blueprints.SkillGemBlueprint;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;

public abstract class BestiaryGroup<T> {
    private static List<BestiaryGroup> all = new ArrayList<BestiaryGroup>();
    public static BestiaryGroup<?> CURRENCY = new BestiaryGroup<CodeCurrency>(){

        @Override
        public List<BestiaryEntry> getAll(int lvl) {
            return LibDatabase.Currency().getList().stream().map(x -> new BestiaryEntry.Item<ExileCurrency>((ExileCurrency)x, x.getItem().m_7968_())).collect(Collectors.toList());
        }

        @Override
        public Component getName() {
            return Words.Currency.locName();
        }

        @Override
        public String texName() {
            return "currency";
        }
    };
    public static BestiaryGroup<?> AFFIX = new DBItemEntry<Affix>(ExileRegistryTypes.AFFIX, Words.AFFIXES, "affix", x -> {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)x.locName().m_130940_(ChatFormatting.AQUA));
        for (StatMod mod : x.getStats()) {
            list.addAll(mod.getEstimationTooltip(1));
        }
        list.addAll(x.requirements().GetTooltipString());
        list.add((Component)Component.m_237119_());
        list.add((Component)Component.m_237113_((String)("Weight: " + x.weight)));
        list.add((Component)Component.m_237113_((String)("Id: " + x.GUID())));
        list.add((Component)Component.m_237113_((String)("Affix Type: " + x.type.name())));
        return new BestiaryEntry.Tooltip<Affix>((Affix)x, Items.f_42676_.m_5456_().m_7968_(), x.locName().getString(), (List<Component>)list);
    });
    public static BestiaryGroup<?> RUNE = new DBItemEntry<Rune>(ExileRegistryTypes.RUNE, Words.Rune, "rune", x -> new BestiaryEntry.Item<Rune>((Rune)x, x.getItem().m_7968_()));
    public static BestiaryGroup<?> GEM = new DBItemEntry<Gem>(ExileRegistryTypes.GEM, Words.Gem, "gem", x -> new BestiaryEntry.Item<Gem>((Gem)x, x.getItem().m_7968_()));
    public static BestiaryGroup<?> EFFECT = new DBItemEntry<ExileEffect>(ExileRegistryTypes.EXILE_EFFECT, Words.STATUS_EFFECT, "effect", x -> {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.addAll(x.GetTooltipString(new StatRangeInfo(ModRange.hide())));
        return new BestiaryEntry.Tooltip<ExileEffect>((ExileEffect)x, x.getEffectDisplayItem().m_7968_(), CLOC.translate((FormattedText)x.locName()), (List<Component>)tooltip);
    });
    public static BestiaryGroup<?> RUNEWORD = new DBItemEntry<RuneWord>(ExileRegistryTypes.RUNEWORDS, Words.Runeword, "runeword", x -> {
        ArrayList<Component> tooltip = new ArrayList<Component>();
        tooltip.add((Component)x.locName().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD}));
        tooltip.add((Component)Component.m_237119_());
        MutableComponent slotsText = Words.ON_SLOTS.locName();
        List<MutableComponent> list = x.slots.stream().map(string -> ((GearSlot)ExileDB.GearSlots().get(string)).locName()).toList();
        tooltip.add((Component)slotsText.m_7220_((Component)ExileTooltipUtils.joinMutableComps(list.iterator(), (MutableComponent)Gui.COMMA_SEPARATOR.locName())));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Component.m_237113_((String)RuneWord.join(x.runes.listIterator(), ", ").toUpperCase(Locale.ROOT)).m_130940_(ChatFormatting.RED));
        tooltip.add((Component)Component.m_237119_());
        tooltip.add((Component)Words.Stats.locName().m_130946_(":"));
        for (StatMod stat : x.stats) {
            tooltip.addAll(stat.getEstimationTooltip(1));
        }
        return new BestiaryEntry.Tooltip<RuneWord>((RuneWord)x, Items.f_42517_.m_7968_(), CLOC.translate((FormattedText)x.locName()), (List<Component>)tooltip);
    });
    public static BestiaryGroup<?> UNIQUE_GEAR = new DBItemEntry<UniqueGear>(ExileRegistryTypes.UNIQUE_GEAR, Words.Unique_Gear, "unique_gear", x -> {
        GearBlueprint b = new GearBlueprint(LootInfo.ofLevel(1));
        b.uniquePart.set(x);
        b.rarity.set((GearRarity)ExileDB.GearRarities().get("unique"));
        b.gearItemSlot.set(x.getBaseGear());
        return new BestiaryEntry.NamedItem<UniqueGear>((UniqueGear)x, b.createStack(), CLOC.translate((FormattedText)x.locName()));
    });
    public static BestiaryGroup<?> SPELL = new DBItemEntry<Spell>(ExileRegistryTypes.SPELL, Words.SPELL, "spell", x -> {
        SkillGemBlueprint b = new SkillGemBlueprint(LootInfo.ofLevel(1), SkillGemData.SkillGemType.SKILL);
        b.setType(x.GUID());
        return new BestiaryEntry.NamedItem<Spell>((Spell)x, b.createStack(), CLOC.translate((FormattedText)x.locName())).setIcon(x.getIconLoc());
    });
    public static BestiaryGroup<?> SUPP = new DBItemEntry<SupportGem>(ExileRegistryTypes.SUPPORT_GEM, Words.SUPPGEM, "supp_gem", x -> {
        SkillGemBlueprint b = new SkillGemBlueprint(LootInfo.ofLevel(1), SkillGemData.SkillGemType.SUPPORT);
        b.setType(x.GUID());
        return new BestiaryEntry.NamedItem<SupportGem>((SupportGem)x, b.createStack(), CLOC.translate((FormattedText)x.locName()));
    });
    public static BestiaryGroup<?> AURA = new DBItemEntry<AuraGem>(ExileRegistryTypes.AURA, Words.AURA, "aura", x -> {
        SkillGemBlueprint b = new SkillGemBlueprint(LootInfo.ofLevel(1), SkillGemData.SkillGemType.AURA);
        b.setType(x.GUID());
        return new BestiaryEntry.NamedItem<AuraGem>((AuraGem)x, b.createStack(), CLOC.translate((FormattedText)x.locName()));
    });

    public static List<BestiaryGroup> getAll() {
        if (all.isEmpty()) {
            all.add(CURRENCY);
            all.add(AFFIX);
            all.add(GEM);
            all.add(RUNE);
            all.add(UNIQUE_GEAR);
            all.add(RUNEWORD);
            all.add(AURA);
            all.add(SUPP);
            all.add(EFFECT);
            all.add(SPELL);
            all.add(new ProfExpBestiary());
            AFFIX.addFilter(Words.AFFIX_TYPES, () -> Arrays.stream(Affix.AffixSlot.values()).map(x -> new AffixTypeFilter((Affix.AffixSlot)((Object)((Object)x)))).collect(Collectors.toList()));
            RUNEWORD.addFilter(Words.RUNE_COUNT, () -> {
                HashSet<Integer> nums = new HashSet<Integer>();
                for (RuneWord r : ExileDB.RuneWords().getList()) {
                    nums.add(r.runes.size());
                }
                return nums.stream().map(e -> new RunewordRunesCountFilter((int)e)).collect(Collectors.toList());
            });
        }
        return all;
    }

    public final ResourceLocation getTextureLoc() {
        return new ResourceLocation("mmorpg", "textures/gui/bestiary/group_icons/" + this.texName() + ".png");
    }

    public abstract List<BestiaryEntry> getAll(int var1);

    public abstract Component getName();

    public int getSize() {
        return this.getAll(1).size();
    }

    public abstract String texName();

    public void addFilter(Words word, Supplier<List<GroupFilterEntry>> entries) {
        GroupFilterType filter = new GroupFilterType(this, word, entries);
    }
}

