/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.wiki;

import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;

public abstract class BestiaryEntry<T> {
    public T obj;
    public ItemStack stack;
    public ResourceLocation icon = null;

    public BestiaryEntry(T obj) {
        this.obj = obj;
    }

    public List<Component> getTooltip() {
        List list = this.stack.m_41651_(ClientOnly.getPlayer(), (TooltipFlag)TooltipFlag.f_256752_);
        return list;
    }

    public BestiaryEntry setIcon(ResourceLocation i) {
        this.icon = i;
        return this;
    }

    public abstract String getName();

    public String getCutName() {
        Object t = "";
        int max = 30;
        t = (String)t + this.getName().substring(0, Math.min(max, this.getName().length()));
        if (this.getName().length() > max) {
            t = (String)t + "...";
        }
        return t;
    }

    public boolean isItem() {
        return this.stack != null && !this.stack.m_41619_();
    }

    public static class Tooltip<T>
    extends BestiaryEntry<T> {
        String name;
        List<Component> tooltip;

        public Tooltip(T obj, ItemStack stack, String name, List<Component> tooltip) {
            super(obj);
            this.stack = stack;
            this.name = name;
            this.tooltip = tooltip;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<Component> getTooltip() {
            return this.tooltip;
        }
    }

    public static class NamedItem<T>
    extends BestiaryEntry<T> {
        String name;

        public NamedItem(T obj, ItemStack stack, String name) {
            super(obj);
            this.stack = stack;
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    public static class Item<T>
    extends BestiaryEntry<T> {
        String name;

        public Item(T obj, ItemStack stack) {
            super(obj);
            this.stack = stack;
            this.name = CLOC.translate((FormattedText)stack.m_41786_());
        }

        @Override
        public String getName() {
            return this.name;
        }
    }
}

