/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.screens.skill_tree.buttons;

import com.google.common.collect.HashMultimap;
import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.library_of_exile.main.MyPacket;
import com.robertx22.library_of_exile.main.Packets;
import com.robertx22.library_of_exile.utils.GuiUtils;
import com.robertx22.library_of_exile.utils.TextUTIL;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.perks.PerkStatus;
import com.robertx22.mine_and_slash.database.data.stats.types.UnknownStat;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.BufferInfo;
import com.robertx22.mine_and_slash.gui.screens.skill_tree.SkillTreeScreen;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.vanilla_mc.packets.perks.PerkChangePacket;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PerkButton
extends ImageButton {
    public static int SPACING = 26;
    public static int BIGGEST = 33;
    static ResourceLocation ID = new ResourceLocation("mmorpg", "textures/gui/skill_tree/perk_buttons.png");
    public static ResourceLocation LOCKED_TEX = new ResourceLocation("mmorpg", "textures/gui/locked.png");
    public Perk perk;
    public PointData point;
    public TalentTree school;
    public PlayerData playerData;
    public int originalWidth;
    public int originalHeight;
    public int origX;
    public int origY;
    Minecraft mc = Minecraft.m_91087_();
    SkillTreeScreen screen;
    public String perkid = "";

    public PerkButton(SkillTreeScreen screen, PlayerData playerData, TalentTree school, PointData point, Perk perk, int x, int y) {
        super(x, y, perk.getType().size, perk.getType().size, 0, 0, 1, ID, action -> {});
        this.perk = perk;
        this.point = point;
        this.school = school;
        this.playerData = playerData;
        this.origX = x;
        this.origY = y;
        this.originalWidth = this.f_93618_;
        this.originalHeight = this.f_93619_;
        this.screen = screen;
    }

    public boolean isInside(int x, int y) {
        float scale = 2.0f - this.screen.zoom;
        return GuiUtils.isInRect((int)((int)((float)this.m_252754_() - (float)(this.f_93618_ / 4) * scale)), (int)((int)((float)this.m_252907_() - (float)(this.f_93619_ / 4) * scale)), (int)((int)((float)this.f_93618_ * scale)), (int)((int)((float)this.f_93619_ * scale)), (int)x, (int)y);
    }

    private void setTooltipMOD(GuiGraphics gui, int mouseX, int mouseY) {
        int MmouseX = (int)(1.0f / this.screen.zoom * (float)mouseX);
        int MmouseY = (int)(1.0f / this.screen.zoom * (float)mouseY);
        if (this.isInside(MmouseX, MmouseY)) {
            List<Component> tooltip = this.perk.GetTooltipString(new StatRangeInfo(ModRange.hide()));
            if (this.perk.stats.stream().anyMatch(x -> x.stat.equals(new UnknownStat().GUID()))) {
                tooltip.add((Component)Component.m_237113_((String)("No Perk of this ID found: " + this.perkid)));
            } else if (MMORPG.RUN_DEV_TOOLS || Screen.m_96638_()) {
                tooltip.add((Component)Component.m_237113_((String)("Perk ID: " + this.perkid)));
            }
            this.m_257544_(Tooltip.m_257550_((Component)TextUTIL.mergeList(tooltip)));
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen != null) {
                screen.m_262791_(this.m_278622_(), this.m_262860_(), true);
            }
        } else {
            this.m_257544_(null);
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.screen.mouseRecentlyClickedTicks = 25;
        this.screen.pointClicked = this.point;
        mouseX = (double)(1.0f / this.screen.zoom) * mouseX;
        mouseY = (double)(1.0f / this.screen.zoom) * mouseY;
        if (this.f_93623_ && this.f_93624_) {
            boolean bl = this.m_93680_(mouseX, mouseY);
            if (bl) {
                this.m_7435_(Minecraft.m_91087_().m_91106_());
                if (button == 0) {
                    Packets.sendToServer((MyPacket)new PerkChangePacket(this.school, this.point, PerkChangePacket.ACTION.ALLOCATE));
                }
                if (button == 1) {
                    Packets.sendToServer((MyPacket)new PerkChangePacket(this.school, this.point, PerkChangePacket.ACTION.REMOVE));
                }
                this.m_5716_(mouseX, mouseY);
                return true;
            }
            return false;
        }
        return false;
    }

    float xPos(float offset, float multi) {
        return (float)this.m_252754_() * multi + offset;
    }

    float yPos(float offset, float multi) {
        return (float)this.m_252907_() * multi + offset;
    }

    public void m_87963_(GuiGraphics gui, int mouseX, int mouseY, float pPartialTick) {
        if (!this.screen.shouldRender(this.m_252754_(), this.m_252907_(), this.screen.ctx)) {
            return;
        }
        this.setTooltipMOD(gui, mouseX, mouseY);
        gui.m_280168_().m_85836_();
        float scale = this.getScale(mouseX, mouseY);
        float posMulti = 1.0f / scale;
        float add = MathHelper.clamp(scale - 1.0f, 0.0f, 2.0f);
        float off = (float)this.f_93618_ / -2.0f * add;
        gui.m_280168_().m_252880_(off, off, 0.0f);
        gui.m_280168_().m_85841_(scale, scale, 1.0f);
        PerkStatus status = this.playerData.talents.getStatus((Player)Minecraft.m_91087_().f_91074_, this.school, this.point);
        float offset = this.perk.getType().getOffset();
        RenderSystem.enableDepthTest();
        String search = SkillTreeScreen.SEARCH.m_94155_();
        float opacity = 0.2f;
        if (!search.isEmpty()) {
            if (search.equals(Gui.TALENT_SCREEN_SEARCH_KEYWORD_ALL.locName().getString())) {
                if (status == PerkStatus.CONNECTED) {
                    opacity = 1.0f;
                }
            } else if (this.perk.stats.stream().anyMatch(item -> item.getStat().locName().getString().toLowerCase().contains(search.toLowerCase())) || this.perk.locName().getString().toLowerCase().contains(search.toLowerCase())) {
                opacity = 1.0f;
            } else if (search.equals(Gui.TALENT_SCREEN_SEARCH_KEYWORD_GAME_CHANGER.locName().getString()) && this.perk.getType().equals((Object)Perk.PerkType.MAJOR)) {
                opacity = 1.0f;
            }
        } else {
            opacity = status.getOpacity();
        }
        if (this.playerData.talents.getAllocatedPoints(TalentTree.SchoolType.TALENTS) < 1) {
            opacity = this.perk.getType() == Perk.PerkType.START ? 1.0f : 0.2f;
        }
        Perk.PerkType type = this.perk.type;
        int offcolor = (int)((float)(this.perk.getType().size - 20) / 2.0f);
        HashMultimap<ResourceLocation, BufferInfo> container = this.screen.vertexContainer.map;
        container.put((Object)this.perk.getType().getColorTexture(status), (Object)BufferInfo.of(this.xPos(offcolor, posMulti), this.yPos(offcolor, posMulti), 20, 20, -3.0f, 0.0f, 0.0f, 20, 20, 20, 20, gui.m_280168_().m_85850_().m_252922_()).withRenderInfo(new BufferInfo.RenderInfo(opacity)));
        container.put((Object)this.perk.getType().getBorderTexture(status), (Object)BufferInfo.of(this.xPos(0.0f, posMulti), this.yPos(0.0f, posMulti), -2.0f, 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_, gui.m_280168_().m_85850_().m_252922_()).withRenderInfo(new BufferInfo.RenderInfo(opacity)));
        if (search.isEmpty()) {
            opacity += 0.2f;
        }
        container.put((Object)this.perk.getIcon(), (Object)BufferInfo.of(this.xPos(offset, posMulti), this.yPos(offset, posMulti), -1.0f, 0.0f, 0.0f, type.iconSize, type.iconSize, type.iconSize, type.iconSize, gui.m_280168_().m_85850_().m_252922_()).withRenderInfo(new BufferInfo.RenderInfo(opacity)));
        gui.m_280168_().m_85849_();
    }

    private float getScale(int mouseX, int mouseY) {
        float scale = 2.0f - this.screen.zoom;
        if (this.isInside((int)(1.0f / this.screen.zoom * (float)mouseX), (int)(1.0f / this.screen.zoom * (float)mouseY))) {
            scale = MathHelper.clamp(scale * 1.3f, 1.7f, 2.0f);
        }
        return MathHelper.clamp(scale, 1.5f, 2.0f);
    }
}

