/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.spell_hotbar;

import com.mojang.blaze3d.systems.RenderSystem;
import com.robertx22.library_of_exile.utils.CLOC;
import com.robertx22.library_of_exile.utils.GuiUtils;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.mmorpg.registers.client.KeybindsRegister;
import com.robertx22.mine_and_slash.mmorpg.registers.client.SpellKeybind;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.settings.KeyModifier;

public class SpellOnHotbarRender {
    static int CHARGE_SIZE = 20;
    private static final ResourceLocation CHARGE = new ResourceLocation("mmorpg", "textures/gui/spells/charges/full_charges.png");
    private static final ResourceLocation LOW_CHARGE = new ResourceLocation("mmorpg", "textures/gui/spells/charges/low_charges.png");
    private static final ResourceLocation NO_CHARGE = new ResourceLocation("mmorpg", "textures/gui/spells/charges/no_charges.png");
    private static final ResourceLocation KEY_BG = new ResourceLocation("mmorpg", "textures/gui/spells/keybind_bg.png");
    private static final ResourceLocation MOD_BG = new ResourceLocation("mmorpg", "textures/gui/spells/modbg.png");
    private static final ResourceLocation COOLDOWN_TEX = new ResourceLocation("mmorpg", "textures/gui/spells/cooldown.png");
    public int place;
    public GuiGraphics gui;
    public int x;
    public int y;
    public Spell spell;
    int keyNum = 0;
    boolean disableKeyRender = false;
    Minecraft mc = Minecraft.m_91087_();
    boolean horizontal;

    public SpellOnHotbarRender(boolean horizontal, int place, GuiGraphics gui, int x, int y) {
        this.place = place;
        this.gui = gui;
        this.horizontal = horizontal;
        this.x = x;
        this.y = y;
        if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue()) {
            if (place > 3) {
                if (!SpellKeybind.IS_ON_SECONd_HOTBAR) {
                    this.disableKeyRender = true;
                }
            } else if (SpellKeybind.IS_ON_SECONd_HOTBAR) {
                this.disableKeyRender = true;
            }
        }
        this.keyNum = place;
        if (((Boolean)ClientConfigs.getConfig().HOTBAR_SWAPPING.get()).booleanValue() && SpellKeybind.IS_ON_SECONd_HOTBAR) {
            this.keyNum -= 4;
        }
        this.spell = Load.player(ClientOnly.getPlayer()).getSkillGemInventory().getHotbarGem(place).getSpell();
    }

    public void render() {
        Minecraft mc = Minecraft.m_91087_();
        this.gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.horizontal) {
            this.x += this.place * 20;
        } else {
            this.y += this.place * 20;
        }
        try {
            int xs = this.x;
            int ys = this.y;
            if (this.spell != null) {
                this.gui.m_280163_(this.spell.getIconLoc(), xs, ys, 0.0f, 0.0f, 16, 16, 16, 16);
                if (this.spell.config.charges > 0) {
                    this.drawCharge(xs, ys);
                } else {
                    CooldownsData cds = Load.Unit((Entity)mc.f_91074_).getCooldowns();
                    float percent = (float)cds.getCooldownTicks(this.spell.GUID()) / (float)cds.getNeededTicks(this.spell.GUID());
                    this.drawCooldown(this.gui, percent, xs, ys);
                }
                int xkey = xs + 15;
                int ykey = this.y + 14;
                this.drawKey(xkey, ykey);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawCharge(int xs, int ys) {
        int charges = Load.player((Player)ClientOnly.getPlayer()).spellCastingData.charges.getCharges(this.spell.config.charge_name);
        ResourceLocation chargeTex = CHARGE;
        if (charges == 0) {
            chargeTex = NO_CHARGE;
        } else if (charges != this.spell.config.charges) {
            chargeTex = LOW_CHARGE;
        }
        if (charges == 0) {
            float needed = this.spell.config.charge_regen;
            float currentticks = Load.player((Player)this.mc.f_91074_).spellCastingData.charges.getCurrentTicksChargingOf(this.spell.config.charge_name);
            float ticksleft = needed - currentticks;
            float percent = ticksleft / needed;
            percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
            this.drawCooldown(this.gui, percent, xs, ys);
        }
        int chargex = this.x - 2;
        this.gui.m_280163_(chargeTex, chargex, this.y - 2, 0.0f, 0.0f, CHARGE_SIZE, CHARGE_SIZE, CHARGE_SIZE, CHARGE_SIZE);
    }

    private void drawKey(int xkey, int ykey) {
        if (this.disableKeyRender) {
            return;
        }
        int bgsize = 10;
        RenderSystem.enableBlend();
        float alpha = 0.75f;
        this.gui.m_280246_(alpha, alpha, alpha, alpha);
        this.gui.m_280163_(KEY_BG, xkey - 6, ykey - 6, 0.0f, 0.0f, bgsize, bgsize, bgsize, bgsize);
        this.gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        String txt = CLOC.translate((FormattedText)KeybindsRegister.getSpellHotbar((int)this.keyNum).key.getKey().m_84875_()).toUpperCase(Locale.ROOT);
        txt = txt.substring(0, 1);
        if (KeybindsRegister.getSpellHotbar((int)this.keyNum).key.m_90862_()) {
            txt = this.disableKeyRender ? "" : "";
        }
        GuiUtils.renderScaledText((GuiGraphics)this.gui, (int)(xkey - 1), (int)ykey, (float)1.0f, (String)txt, (ChatFormatting)ChatFormatting.GREEN);
        SpellKeybind key = KeybindsRegister.getSpellHotbar(this.keyNum);
        if (key.key.getKeyModifier() != KeyModifier.NONE) {
            RenderSystem.enableBlend();
            this.gui.m_280246_(alpha, alpha, alpha, alpha);
            this.gui.m_280163_(MOD_BG, xkey - 18, ykey - 6, 0.0f, 0.0f, 13, bgsize, 13, bgsize);
            this.gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
            String modtext = KeybindsRegister.getSpellHotbar((int)this.keyNum).key.getKeyModifier().toString().substring(0, 3);
            GuiUtils.renderScaledText((GuiGraphics)this.gui, (int)(xkey - 11), (int)ykey, (float)0.6f, (String)modtext, (ChatFormatting)ChatFormatting.YELLOW);
        }
        RenderSystem.disableBlend();
    }

    private void drawCooldown(GuiGraphics gui, float percent, int xs, int ys) {
        percent = Mth.m_14036_((float)percent, (float)0.0f, (float)1.0f);
        CooldownsData cds = Load.Unit((Entity)this.mc.f_91074_).getCooldowns();
        if (cds.getCooldownTicks(this.spell.GUID()) <= 1) {
            return;
        }
        gui.m_280163_(COOLDOWN_TEX, this.x, this.y, 0.0f, 0.0f, 16, (int)(16.0f * percent), 16, 16);
        int cdsec = cds.getCooldownTicks(this.spell.GUID()) / 20;
        if (cdsec > 1) {
            String string = cdsec + "s";
        }
    }
}

