/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.overlays.spell_cast_bar;

import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayConfig;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayType;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class SpellCastBarOverlay {
    static ResourceLocation GUI_BARS_TEXTURES = new ResourceLocation("mmorpg", "textures/gui/spells/cast_bar/cast_bar.png");
    static ResourceLocation FILLED = new ResourceLocation("mmorpg", "textures/gui/spells/cast_bar/cast_bar_fill.png");
    static int WIDTH = 172;
    static int HEIGHT = 20;
    Minecraft mc = Minecraft.m_91087_();

    public void onHudRender(GuiGraphics gui, float partialtick) {
        PlayerData data = Load.player((Player)this.mc.f_91074_);
        if (data == null) {
            return;
        }
        if (data.spellCastingData.isCasting() && data.spellCastingData.castTickLeft > 0) {
            float total = data.spellCastingData.spellTotalCastTicks;
            float current = data.spellCastingData.castTickLeft;
            float percent = (total - current + partialtick) / total;
            this.renderCastBar(gui, data.spellCastingData.getSpellBeingCast(), percent);
        }
    }

    private void renderCastBar(GuiGraphics gui, Spell spell, float percent) {
        int spellSize = 14;
        int x = this.mc.m_91268_().m_85445_() / 2 - WIDTH / 2;
        int y = (int)((float)this.mc.m_91268_().m_85446_() / 1.25f - (float)(HEIGHT / 2));
        OverlayConfig config = ClientConfigs.getConfig().getOverlayConfig(OverlayType.SPELL_CAST_BAR);
        x = config.getPos().x;
        y = config.getPos().y;
        gui.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
        gui.m_280163_(GUI_BARS_TEXTURES, x, y, 0.0f, 0.0f, WIDTH, HEIGHT, WIDTH, HEIGHT);
        int i = (int)(percent * (float)WIDTH);
        if (i > 0) {
            gui.m_280163_(FILLED, x, y, 0.0f, 0.0f, i, HEIGHT, WIDTH, HEIGHT);
        }
        gui.m_280163_(spell.getIconLoc(), x + 79, y + 3, 0.0f, 0.0f, spellSize, spellSize, spellSize, spellSize);
    }
}

