/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.gui.inv_gui.actions;

import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.GuiConfigToggle;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.PickSpellAction;
import com.robertx22.mine_and_slash.gui.inv_gui.actions.auto_salvage.ToggleAutoSalvageRarity;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class GuiAction<T>
implements IGUID {
    private static HashMap<String, GuiAction> map = new HashMap();

    public static GuiAction get(String id) {
        if (!map.containsKey(id)) {
            GuiAction.regenActionMap();
        }
        return map.getOrDefault(id, new GuiAction(){

            @Override
            public void saveExtraData(FriendlyByteBuf buf) {
            }

            public Object loadExtraData(FriendlyByteBuf buf) {
                return null;
            }

            @Override
            public List<Component> getTooltip(Player p) {
                return Arrays.asList(new Component[0]);
            }

            @Override
            public void doAction(Player p, Object d) {
            }

            @Override
            public void clientAction(Player p, Object obj) {
            }

            public String GUID() {
                return "empty";
            }
        });
    }

    private static void of(GuiAction a) {
        if (!map.containsKey(a.GUID())) {
            map.put(a.GUID(), a);
        }
    }

    public static void regenActionMap() {
        for (PlayerConfigData.Config config : PlayerConfigData.Config.values()) {
            GuiAction.of(new GuiConfigToggle(config));
        }
        for (Enum enum_ : ToggleAutoSalvageRarity.SalvageType.values()) {
            for (GearRarity rar : ExileDB.GearRarities().getList()) {
                GuiAction.of(new ToggleAutoSalvageRarity((ToggleAutoSalvageRarity.SalvageType)enum_, rar));
            }
        }
        for (Spell rw : ExileDB.Spells().getList()) {
            GuiAction.of(new PickSpellAction(rw));
        }
    }

    public ResourceLocation getIcon() {
        return SlashRef.id("textures/gui/inv_gui/icons/" + this.GUID() + ".png");
    }

    public ResourceLocation getBackGroundIcon() {
        return null;
    }

    public abstract void saveExtraData(FriendlyByteBuf var1);

    public abstract T loadExtraData(FriendlyByteBuf var1);

    public abstract List<Component> getTooltip(Player var1);

    public abstract void doAction(Player var1, Object var2);

    public abstract void clientAction(Player var1, Object var2);
}

