/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.event_hooks.my_events;

import com.robertx22.mine_and_slash.capability.DirtySync;
import com.robertx22.mine_and_slash.capability.player.PlayerData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.saveclasses.unit.stat_ctx.StatContext;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.CommonStatUtils;
import com.robertx22.mine_and_slash.uncommon.stat_calculation.PlayerStatUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CachedPlayerStats {
    public Player p;
    public List<StatContext> allStatsWithoutSuppGems = new ArrayList<StatContext>();
    public List<StatContext> statContexts = new ArrayList<StatContext>();
    public StatContext enchantCompat = null;
    private StatContext statCompat;
    public DirtySync ENCHANT_COMPAT = new DirtySync("enchant_compat", x -> {
        this.enchantCompat = GearItemData.getEnchantCompatStats(this.p, Load.Unit((Entity)this.p).equipmentCache.getGear());
    });
    public DirtySync STAT_COMPAT = new DirtySync("stat_compat", x -> {
        this.recalcStatCompat();
        Load.Unit((Entity)this.p).equipmentCache.STAT_CALC.setDirty();
    });
    public StatContext omenStats;
    public DirtySync ALLOCATED = new DirtySync("misc_player", x -> {
        this.recalcAllocated();
        Load.Unit((Entity)this.p).equipmentCache.STAT_CALC.setDirty();
    }){

        @Override
        public void setDirty() {
            super.setDirty();
        }
    };

    public StatContext getStatCompatStats() {
        if (this.statCompat == null) {
            this.recalcStatCompat();
        }
        return this.statCompat;
    }

    private void recalcStatCompat() {
        this.statCompat = CommonStatUtils.addStatCompat((LivingEntity)this.p);
    }

    public void setAllDirty() {
        this.ALLOCATED.setDirty();
        this.ENCHANT_COMPAT.setDirty();
        this.STAT_COMPAT.setDirty();
    }

    public void tick() {
        this.ALLOCATED.onTickTrySync((Entity)this.p);
        this.ENCHANT_COMPAT.onTickTrySync((Entity)this.p);
        this.STAT_COMPAT.onTickTrySync((Entity)this.p);
    }

    public CachedPlayerStats(Player p) {
        this.p = p;
    }

    private void recalcAllocated() {
        this.statContexts = new ArrayList<StatContext>();
        PlayerData playerData = Load.player(this.p);
        playerData.aurasOn = new ArrayList<String>();
        for (SkillGemData aura : playerData.getSkillGemInventory().getAurasGems()) {
            playerData.aurasOn.add(aura.id);
        }
        this.statContexts.addAll(PlayerStatUtils.addToolStats(this.p));
        this.statContexts.add(PlayerStatUtils.addBonusExpPerCharacters(this.p));
        this.statContexts.addAll(playerData.buff.getStatAndContext((LivingEntity)this.p));
        this.statContexts.addAll(playerData.getSkillGemInventory().getAuraStats((LivingEntity)this.p));
        this.statContexts.addAll(playerData.getJewels().getStatAndContext((LivingEntity)this.p));
        this.statContexts.addAll(playerData.statPoints.getStatAndContext((LivingEntity)this.p));
        this.statContexts.addAll(PlayerStatUtils.addNewbieElementalResists(Load.Unit((Entity)this.p)));
        this.statContexts.addAll(playerData.talents.getStatAndContext((LivingEntity)this.p));
        this.statContexts.addAll(playerData.ascClass.getStatAndContext((LivingEntity)this.p));
        this.statContexts.addAll(playerData.prophecy.getStatAndContext((LivingEntity)this.p));
    }
}

