/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.registry;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.addon.ExtendedOrb;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.Database;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryContainer;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailment;
import com.robertx22.mine_and_slash.capability.entity.EntityData;
import com.robertx22.mine_and_slash.database.data.DimensionConfig;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.affixes.Affix;
import com.robertx22.mine_and_slash.database.data.aura.AuraGem;
import com.robertx22.mine_and_slash.database.data.auto_item.AutoItem;
import com.robertx22.mine_and_slash.database.data.base_stats.BaseStatsConfig;
import com.robertx22.mine_and_slash.database.data.chaos_stats.ChaosStat;
import com.robertx22.mine_and_slash.database.data.custom_item.CustomItem;
import com.robertx22.mine_and_slash.database.data.exile_effects.ExileEffect;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.gear_types.bases.BaseGearType;
import com.robertx22.mine_and_slash.database.data.gems.Gem;
import com.robertx22.mine_and_slash.database.data.loot_chest.base.LootChest;
import com.robertx22.mine_and_slash.database.data.map_affix.MapAffix;
import com.robertx22.mine_and_slash.database.data.mob_affixes.MobAffix;
import com.robertx22.mine_and_slash.database.data.omen.Omen;
import com.robertx22.mine_and_slash.database.data.perks.Perk;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.database.data.profession.buffs.StatBuff;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyModifier;
import com.robertx22.mine_and_slash.database.data.prophecy.ProphecyStart;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.data.runes.Rune;
import com.robertx22.mine_and_slash.database.data.runewords.RuneWord;
import com.robertx22.mine_and_slash.database.data.spell_school.SpellSchool;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stat_compat.StatCompat;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayer;
import com.robertx22.mine_and_slash.database.data.support_gem.SupportGem;
import com.robertx22.mine_and_slash.database.data.talent_tree.TalentTree;
import com.robertx22.mine_and_slash.database.data.unique_items.UniqueGear;
import com.robertx22.mine_and_slash.database.data.value_calc.ValueCalculation;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action.StatEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.condition.StatCondition;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.MapManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.registries.ForgeRegistries;

public class ExileDB {
    public static DimensionConfig getDimensionConfig(LevelAccessor world) {
        String id = MapManager.getResourceLocation((Level)world).toString();
        if (!ExileDB.DimensionConfigs().isRegistered(id)) {
            return (DimensionConfig)ExileDB.DimensionConfigs().get(DimensionConfig.DEFAULT_ID);
        }
        return (DimensionConfig)ExileDB.DimensionConfigs().get(id);
    }

    public static EntityConfig getEntityConfig(LivingEntity entity, EntityData data) {
        ResourceLocation id = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        String monster_id = id.toString();
        String mod_id = id.m_135827_();
        EntityConfig config = null;
        if (ExileDB.EntityConfigs().isRegistered(monster_id) ? (config = (EntityConfig)ExileDB.EntityConfigs().get(monster_id)) != null : (ExileDB.EntityConfigs().isRegistered(mod_id) ? (config = (EntityConfig)ExileDB.EntityConfigs().get(mod_id)) != null : (config = (EntityConfig)ExileDB.EntityConfigs().get(data.getType().id)) != null)) {
            return config;
        }
        return (EntityConfig)ExileDB.EntityConfigs().getDefault();
    }

    public static ExileRegistryContainer<GearSlot> GearSlots() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.GEAR_SLOT);
    }

    public static ExileRegistryContainer<UniqueGear> UniqueGears() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.UNIQUE_GEAR);
    }

    public static ExileRegistryContainer<ExtendedOrb> OrbExtension() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.ORB_EXTEND);
    }

    public static ExileRegistryContainer<DimensionConfig> DimensionConfigs() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.DIMENSION_CONFIGS);
    }

    public static ExileRegistryContainer<StatCondition> StatConditions() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.STAT_CONDITION);
    }

    public static ExileRegistryContainer<StatEffect> StatEffects() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.STAT_EFFECT);
    }

    public static ExileRegistryContainer<Gem> Gems() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.GEM);
    }

    public static ExileRegistryContainer<ExileEffect> ExileEffects() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.EXILE_EFFECT);
    }

    public static ExileRegistryContainer<TalentTree> TalentTrees() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.TALENT_TREE);
    }

    public static ExileRegistryContainer<Perk> Perks() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.PERK);
    }

    public static ExileRegistryContainer<Rune> Runes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.RUNE);
    }

    public static ExileRegistryContainer<RuneWord> RuneWords() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.RUNEWORDS);
    }

    public static ExileRegistryContainer<Affix> Affixes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.AFFIX);
    }

    public static ExileRegistryContainer<GearRarity> GearRarities() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.GEAR_RARITY);
    }

    public static ExileRegistryContainer<MobRarity> MobRarities() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.MOB_RARITY);
    }

    public static ExileRegistryContainer<ProphecyModifier> ProphecyModifiers() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.PROPHECY_MODIFIER);
    }

    public static ExileRegistryContainer<ProphecyStart> ProphecyStarts() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.PROPHECY_START);
    }

    public static ExileRegistryContainer<BaseGearType> GearTypes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.GEAR_TYPE);
    }

    public static ExileRegistryContainer<Spell> Spells() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.SPELL);
    }

    public static ExileRegistryContainer<MobAffix> MobAffixes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.MOB_AFFIX);
    }

    public static ExileRegistryContainer<Ailment> Ailments() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.AILMENT);
    }

    public static ExileRegistryContainer<ValueCalculation> ValueCalculations() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.VALUE_CALC);
    }

    public static ExileRegistryContainer<Omen> Omens() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.OMEN);
    }

    public static ExileRegistryContainer<StatLayer> StatLayers() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.STAT_LAYER);
    }

    public static ExileRegistryContainer<EntityConfig> EntityConfigs() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.ENTITY_CONFIGS);
    }

    public static ExileRegistryContainer<SpellSchool> SpellSchools() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.SPELL_SCHOOL);
    }

    public static ExileRegistryContainer<MapAffix> MapAffixes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.MAP_AFFIX);
    }

    public static ExileRegistryContainer<LootChest> LootChests() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.LOOT_CHEST);
    }

    public static ExileRegistryContainer<SupportGem> SupportGems() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.SUPPORT_GEM);
    }

    public static ExileRegistryContainer<Profession> Professions() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.PROFESSION);
    }

    public static ExileRegistryContainer<AutoItem> AutoItems() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.AUTO_ITEM);
    }

    public static ExileRegistryContainer<CustomItem> CustomItemGenerations() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.CUSTOM_ITEM);
    }

    public static ExileRegistryContainer<StatBuff> StatBuffs() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.STAT_BUFF);
    }

    public static ExileRegistryContainer<ChaosStat> ChaosStats() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.CHAOS_STAT);
    }

    public static ExileRegistryContainer<ProfessionRecipe> Recipes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.RECIPE);
    }

    public static ExileRegistryContainer<WeaponTypes> WeaponTypes() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.WEAPON_TYPE);
    }

    public static ExileRegistryContainer<StatCompat> StatCompat() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.STAT_COMPAT);
    }

    public static ExileRegistryContainer<AuraGem> AuraGems() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.AURA);
    }

    public static ExileRegistryContainer<Stat> Stats() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.STAT);
    }

    public static ExileRegistryContainer<BaseStatsConfig> BaseStats() {
        return Database.getRegistry((ExileRegistryType)ExileRegistryTypes.BASE_STATS);
    }

    public static void checkAllDatabasesHaveDefaultEmpty() {
        if (MMORPG.RUN_DEV_TOOLS) {
            for (ExileRegistryType type : ExileRegistryType.getAllInRegisterOrder()) {
                ExileRegistryContainer reg = Database.getRegistry((ExileRegistryType)type);
                if (reg == null) {
                    ExileLog.get().warn(type.id + " registry returns null", new Object[0]);
                    continue;
                }
                ExileRegistry em = reg.getDefault();
                if (em != null) continue;
                ExileLog.get().warn(type.id + " default is null or not registered", new Object[0]);
            }
        }
    }
}

