/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.resources;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.saveclasses.unit.ResourceType;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import net.minecraft.util.Mth;

public class DamageAbsorbedByMana
extends Stat {
    public static String GUID = "mana_shield";

    private DamageAbsorbedByMana() {
        this.min = 0.0f;
        this.scaling = StatScaling.NONE;
        this.group = Stat.StatGroup.MAIN;
    }

    public static DamageAbsorbedByMana getInstance() {
        return SingletonHolder.INSTANCE;
    }

    @Override
    public String locDescForLangFile() {
        return "Percent of damage is absorbed by Mana if remaining Mana is greater than 50 percent of max Mana.";
    }

    public String GUID() {
        return GUID;
    }

    @Override
    public Elements getElement() {
        return null;
    }

    @Override
    public boolean IsPercent() {
        return true;
    }

    @Override
    public String locNameForLangFile() {
        return "Of Damage Absorbed By Mana";
    }

    public static float modifyEntityDamage(DamageEvent effect, float dmg) {
        StatData data = effect.targetData.getUnit().getCalculatedStat(DamageAbsorbedByMana.getInstance());
        if (data.getValue() <= 0.0f) {
            return dmg;
        }
        float currentMana = effect.targetData.getResources().getMana();
        if (currentMana / effect.targetData.getUnit().manaData().getValue() > 0.5f) {
            float maxMana = effect.targetData.getUnit().manaData().getValue();
            float dmgReduced = Mth.m_14036_((float)(dmg * data.getValue() / 100.0f), (float)0.0f, (float)(currentMana - maxMana * 0.5f));
            if (dmgReduced > 0.0f) {
                effect.targetData.getResources().spend(effect.target, ResourceType.mana, dmgReduced);
                return dmg - dmgReduced;
            }
        }
        return dmg;
    }

    private static class SingletonHolder {
        private static final DamageAbsorbedByMana INSTANCE = new DamageAbsorbedByMana();

        private SingletonHolder() {
        }
    }
}

