/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.types.generated;

import com.robertx22.mine_and_slash.database.data.stats.IUsableStat;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.StatGuiGroup;
import com.robertx22.mine_and_slash.database.data.stats.StatScaling;
import com.robertx22.mine_and_slash.database.data.stats.effects.defense.ElementalResistEffect;
import com.robertx22.mine_and_slash.database.data.stats.effects.defense.MaxElementalResist;
import com.robertx22.mine_and_slash.database.data.stats.types.ElementalStat;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.saveclasses.unit.Unit;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.wrappers.MapWrapper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;

public class ElementalResist
extends ElementalStat
implements IUsableStat {
    public static MapWrapper<Elements, ElementalResist> MAP = new MapWrapper();
    static HashMap<Elements, MaxElementalResist> cached = new HashMap();

    @Override
    public List<Stat> generateAllPossibleStatVariations() {
        List<Stat> list = super.generateAllPossibleStatVariations();
        list.forEach(x -> MAP.put(x.getElement(), (ElementalResist)x));
        return list;
    }

    public ElementalResist(Elements element) {
        super(element);
        this.gui_group = StatGuiGroup.RESIST;
        this.min = -300.0f;
        this.group = Stat.StatGroup.ELEMENTAL;
        this.is_perc = true;
        this.scaling = StatScaling.NONE;
        this.format = element.format.m_126666_();
        this.icon = element.icon;
        this.statEffect = new ElementalResistEffect();
        this.max = 500.0f;
    }

    @Override
    public ChatFormatting getStatGuiTooltipNumberColor(StatData data) {
        float val = data.getValue();
        if (val > 75.0f) {
            return ChatFormatting.LIGHT_PURPLE;
        }
        if (val > 70.0f) {
            return ChatFormatting.GREEN;
        }
        if (val > 25.0f) {
            return ChatFormatting.YELLOW;
        }
        return ChatFormatting.RED;
    }

    MaxElementalResist getMaxStat() {
        return cached.computeIfAbsent(this.getElement(), x -> new MaxElementalResist((Elements)((Object)x)));
    }

    @Override
    public float getAdditionalMax(Unit data) {
        return data.getCalculatedStat(this.getMaxStat()).getValue();
    }

    @Override
    public Stat newGeneratedInstance(Elements element) {
        return new ElementalResist(element);
    }

    public String GUID() {
        return this.getElement().guidName + "_resist";
    }

    @Override
    public String locDescForLangFile() {
        return "Stops X percent damage of that element";
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.stat_desc.ele_resist";
    }

    @Override
    public String locNameForLangFile() {
        return this.getElement().dmgName + " Resistance";
    }

    @Override
    public float getMaxMulti() {
        return 0.0f;
    }

    @Override
    public float valueNeededToReachMaximumPercentAtLevelOne() {
        return 0.0f;
    }

    @Override
    public float getUsableValue(Unit unit, int value, int lvl) {
        float max = MathHelper.clamp(75.0f + this.getAdditionalMax(unit), this.min, 90.0f);
        float min = this.min;
        return MathHelper.clamp((float)value, min, max) / 100.0f;
    }
}

