/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.tooltips;

import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.stats.IUsableStat;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.tooltips.IStatTooltipType;
import com.robertx22.mine_and_slash.database.data.stats.types.LearnSpellStat;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class NormalStatTooltip
implements IStatTooltipType {
    @Override
    public List<MutableComponent> getTooltipList(ChatFormatting format, TooltipStatWithContext ctx) {
        TooltipStatInfo info = ctx.statinfo;
        ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
        MutableComponent txt = Component.m_237113_((String)"").m_7220_((Component)Component.m_237113_((String)info.stat.getStatNameRegex().translate(format, ctx, info.type, info.firstValue, info.stat)).m_130940_(ChatFormatting.BLUE));
        if (ctx.statinfo.stat.is_long) {
            return this.longStat(ctx, txt);
        }
        if (ctx.showStatRanges()) {
            txt.m_130946_(" ").m_7220_((Component)NormalStatTooltip.getPercentageView(info.percent, ctx.mod, ctx.statinfo.affix_rarity, ctx.level, info.tooltipInfo.minmax));
        }
        list.add(txt);
        if (info.shouldShowDescriptions() && !(info.stat instanceof LearnSpellStat)) {
            list.addAll(info.stat.getCutDescTooltip());
            Stat stat = ctx.statinfo.stat;
            if (stat instanceof IUsableStat) {
                IUsableStat usable = (IUsableStat)((Object)stat);
                list.add(Component.m_237113_((String)"Formula: Stat Percent = statNum / ( base + statNum)"));
            }
        }
        return list;
    }

    public static MutableComponent getPercentageView(int perc, StatMod mod, GearRarity rar, int lvl, ModRange max) {
        if (mod == null || max.hide) {
            return Component.m_237119_();
        }
        ChatFormatting format = ChatFormatting.RED;
        if (perc > 25) {
            format = ChatFormatting.YELLOW;
        }
        if (perc > 50) {
            format = ChatFormatting.GREEN;
        }
        if (perc > 75) {
            format = ChatFormatting.AQUA;
        }
        if (perc > 90) {
            format = ChatFormatting.LIGHT_PURPLE;
        }
        if (rar != null) {
            format = rar.textFormatting();
        }
        float v1 = mod.ToExactStat(max.minmax.min, lvl).getValue();
        float v2 = mod.ToExactStat(max.minmax.max, lvl).getValue();
        MutableComponent mid = Component.m_237113_((String)((int)v1 + " - " + (int)v2));
        MutableComponent text = Component.m_237113_((String)" [").m_7220_((Component)mid).m_130946_("]").m_130940_(format);
        if (rar != null) {
            text.m_7220_((Component)Component.m_237113_((String)(" [" + TooltipUtils.rarityShort(rar).getString() + "]")).m_130940_(rar.textFormatting()));
        }
        return text;
    }
}

