/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.layers;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.stats.layers.StatLayerData;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class StatLayer
implements JsonExileRegistry<StatLayer>,
IAutoGson<StatLayer>,
IAutoLocName {
    public static StatLayer SERIALIZER = new StatLayer();
    public static List<StatLayer> ALL = new ArrayList<StatLayer>();
    public String id = "";
    public String name = "";
    public int priority = 0;
    public float min_multi = -1.0f;
    public float max_multi = 1000.0f;
    public LayerAction action = LayerAction.MULTIPLY;

    private StatLayer() {
    }

    public MutableComponent getTooltip(EffectEvent event, StatLayerData data) {
        MutableComponent convtext;
        MutableComponent sourcetarget = Component.m_237119_().m_130946_("[").m_7220_((Component)data.side.word.locName().m_130946_("]: "));
        MutableComponent number = Component.m_237113_((String)("x" + MMORPG.DECIMAL_FORMAT.format(data.getMultiplier())));
        MutableComponent locname = this.locName();
        if (this.action == LayerAction.ADD) {
            String plusminus = data.getNumber() < 0.0f ? "" : "+";
            number = Component.m_237113_((String)(plusminus + MMORPG.DECIMAL_FORMAT.format(data.getNumber())));
        }
        if (this.action == LayerAction.CONVERT_PERCENT) {
            convtext = Component.m_237113_((String)"");
            for (Map.Entry<Elements, Float> en : data.conversion.totals.entrySet()) {
                Elements ele = en.getKey();
                Float perc = en.getValue();
                locname = this.locName(new Object[]{event.data.getElement().getIconNameDmg(), ele.getIconNameDmg()});
                number = Component.m_237113_((String)(perc + "%"));
                MutableComponent t = Component.m_237119_().m_7220_((Component)sourcetarget).m_7220_((Component)locname.m_130946_(": ").m_7220_((Component)number));
                convtext.m_7220_((Component)t.m_130946_("\n"));
            }
            return convtext;
        }
        if (this.action == LayerAction.DAMAGE_TAKEN_AS) {
            convtext = Component.m_237113_((String)"");
            for (Map.Entry<Elements, Float> en : data.damageTakenAs.totals.entrySet()) {
                Elements ele = en.getKey();
                Float perc = en.getValue();
                locname = this.locName(new Object[]{event.data.getElement().getIconNameDmg(), ele.getIconNameDmg()});
                number = Component.m_237113_((String)(perc + "%"));
                MutableComponent t = Component.m_237119_().m_7220_((Component)sourcetarget).m_7220_((Component)locname.m_130946_(": ").m_7220_((Component)number));
                convtext.m_7220_((Component)t.m_130946_("\n"));
            }
            return convtext;
        }
        if (this.action == LayerAction.X_AS_BONUS_Y_ELEMENT_DAMAGE) {
            locname = this.locName(new Object[]{event.data.getElement().getIconNameDmg(), data.additionalConversion.to.getIconNameDmg()});
            number = Component.m_237113_((String)(data.additionalConversion.percent + "%"));
        }
        MutableComponent t = Component.m_237119_().m_7220_((Component)sourcetarget).m_7220_((Component)locname.m_130946_(": ").m_7220_((Component)number));
        return t;
    }

    public StatLayer(String id, String name, LayerAction action, int priority, float min_multi, float max_multi) {
        this.id = id;
        this.action = action;
        this.name = name;
        this.priority = priority;
        this.min_multi = min_multi;
        this.max_multi = max_multi;
        ALL.add(this);
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.STAT_LAYER;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.stat_layer." + this.id;
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.STAT_LAYER;
    }

    public Class<StatLayer> getClassForSerialization() {
        return StatLayer.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum LayerAction {
        CONVERT_PERCENT{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                if (event instanceof DamageEvent) {
                    DamageEvent effect = (DamageEvent)event;
                    if (!event.data.isNumberSetup(EventData.BEFORE_CONVERSION_NUMBER)) {
                        event.data.getNumber(EventData.BEFORE_CONVERSION_NUMBER, effect.data.getNumber((String)EventData.NUMBER).number);
                    }
                    if (!layer.conversion.normalized) {
                        layer.conversion.normalizeNumbersToCapTo100();
                    }
                    float original = effect.data.getNumber((String)EventData.BEFORE_CONVERSION_NUMBER).number;
                    for (Map.Entry<Elements, Float> en : layer.conversion.totals.entrySet()) {
                        Elements ele = en.getKey();
                        float conv = en.getValue().floatValue();
                        if (conv > 100.0f) {
                            conv = 100.0f;
                        }
                        if (conv > effect.unconvertedDamagePercent) {
                            conv = effect.unconvertedDamagePercent;
                        }
                        if (conv <= 0.0f) {
                            return;
                        }
                        effect.unconvertedDamagePercent -= conv;
                        float dmg = original * conv / 100.0f;
                        if (!((dmg = MathHelper.clamp(dmg, 0.0f, original)) > 0.0f)) continue;
                        effect.addBonusEleDmg(ele, dmg, layer.side);
                        event.data.getNumber((String)EventData.NUMBER).number -= dmg;
                    }
                }
            }
        }
        ,
        DAMAGE_TAKEN_AS{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                if (event instanceof DamageEvent) {
                    DamageEvent effect = (DamageEvent)event;
                    if (!layer.damageTakenAs.normalized) {
                        layer.damageTakenAs.normalizeNumbersToCapTo100();
                    }
                    float original = effect.data.getNumber((String)EventData.NUMBER).number;
                    for (Map.Entry<Elements, Float> en : layer.damageTakenAs.totals.entrySet()) {
                        Elements ele = en.getKey();
                        float conv = en.getValue().floatValue();
                        if (conv > 100.0f) {
                            conv = 100.0f;
                        }
                        if (conv > effect.unconvertedDamageTakenAsPercent) {
                            conv = effect.unconvertedDamageTakenAsPercent;
                        }
                        if (conv <= 0.0f) {
                            return;
                        }
                        effect.unconvertedDamageTakenAsPercent -= conv;
                        float dmg = original * conv / 100.0f;
                        if (!((dmg = MathHelper.clamp(dmg, 0.0f, original)) > 0.0f)) continue;
                        effect.addBonusEleDmg(ele, dmg, layer.side);
                        event.data.getNumber((String)EventData.NUMBER).number -= dmg;
                    }
                }
            }
        }
        ,
        X_AS_BONUS_Y_ELEMENT_DAMAGE{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                float conv = layer.additionalConversion.percent;
                if (event instanceof DamageEvent) {
                    DamageEvent effect = (DamageEvent)event;
                    if (conv <= 0.0f) {
                        return;
                    }
                    float dmg = effect.data.getNumber((String)EventData.NUMBER).number * conv / 100.0f;
                    if ((dmg = MathHelper.clamp(dmg, 0.0f, Float.MAX_VALUE)) > 0.0f) {
                        effect.addBonusEleDmg(layer.additionalConversion.to, dmg, layer.side);
                    }
                }
            }
        }
        ,
        MULTIPLY{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                float multi = layer.getMultiplier();
                event.data.getNumber((String)number).number *= multi;
            }
        }
        ,
        ADD{

            @Override
            public void apply(EffectEvent event, StatLayerData layer, String number) {
                event.data.getNumber((String)number).number += layer.getNumber();
            }
        };


        public abstract void apply(EffectEvent var1, StatLayerData var2, String var3);
    }
}

