/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.datapacks.test;

import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.mine_and_slash.aoe_data.database.stats.DefenseStats;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.priority.StatPriority;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EffectEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.action.StatEffect;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.condition.StatCondition;
import com.robertx22.mine_and_slash.uncommon.interfaces.EffectSides;
import com.robertx22.mine_and_slash.uncommon.interfaces.IStatEffect;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class DataPackStatEffect
implements IStatEffect {
    public String order = "";
    public EffectSides side = EffectSides.Source;
    public List<String> ifs = new ArrayList<String>();
    public List<String> effects = new ArrayList<String>();
    public List<String> events = new ArrayList<String>();

    @Override
    public boolean worksOnEvent(EffectEvent ev) {
        return this.events.contains(ev.GUID());
    }

    @Override
    public EffectSides Side() {
        return this.side;
    }

    public List<MutableComponent> getTooltip() {
        ArrayList<MutableComponent> t = new ArrayList<MutableComponent>();
        StatPriority prio = this.GetPriority();
        t.add(Component.m_237113_((String)"Priority: ").m_7220_((Component)prio.locName()).m_130946_(" (" + prio.priority + ")"));
        t.add(this.side.word.locName());
        t.add(Words.WorksOnEvent.locName());
        for (String event : this.events) {
            t.add(Component.m_237113_((String)event));
        }
        t.add(Words.Conditions.locName());
        for (String i : this.ifs) {
            t.add(Component.m_237113_((String)("- " + i)));
        }
        t.add(Words.Effects.locName());
        for (String i : this.effects) {
            t.add(Component.m_237113_((String)("- " + i)));
        }
        return t;
    }

    @Override
    public StatPriority GetPriority() {
        StatPriority p = StatPriority.MAP.get(this.order);
        if (p == null) {
            ExileLog.get().warn("No such stat priority: " + this.order, new Object[0]);
            return StatPriority.Spell.FIRST;
        }
        return p;
    }

    @Override
    public void TryModifyEffect(EffectEvent effect, EffectSides statSource, StatData data, Stat stat) {
        if (MMORPG.RUN_DEV_TOOLS && stat.GUID().equals(DefenseStats.NO_SELF_DAMAGE_STATS.getId())) {
            boolean bl = true;
        }
        if (this.ifs.stream().allMatch(x -> {
            StatCondition cond = (StatCondition)ExileDB.StatConditions().get(x);
            if (cond == null) {
                return false;
            }
            Boolean istrue = cond.can(effect, statSource, data, stat) == cond.getConditionBoolean();
            return istrue;
        })) {
            this.effects.forEach(x -> {
                StatEffect e = (StatEffect)ExileDB.StatEffects().get(x);
                if (e == null) {
                    return;
                }
                e.activate(effect, statSource, data, stat);
            });
        }
    }
}

