/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.stats.datapacks.test;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EmptyAccessor;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.datapacks.test.DatapackStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class DataPackStatAccessor<T extends IGUID> {
    private HashMap<T, String> map = new HashMap();
    private HashMap<T, Stat> map2 = new HashMap();

    public boolean has(T key) {
        return this.map.containsKey(key);
    }

    public Stat get(T key) {
        if (!ExileDB.Stats().isRegistered(this.getId(key))) {
            Stat stat = this.map2.get(key);
            if (stat == null) {
                throw new RuntimeException(key.GUID() + " is null");
            }
            return stat;
        }
        Stat stat = (Stat)ExileDB.Stats().get(this.map.get(key));
        Objects.requireNonNull(stat, "Null for " + key.toString());
        return stat;
    }

    public String getId(T key) {
        return this.map.get(key);
    }

    public String getId() {
        return this.getId(EmptyAccessor.INSTANCE);
    }

    public void add(T key, DatapackStat stat) {
        this.map.put(key, stat.id);
        this.map2.put(key, stat);
    }

    public List<Stat> getAll() {
        if (ExileDB.Stats().isRegistered((ExileRegistry)this.map2.values().stream().findFirst().get())) {
            return this.map.values().stream().map(x -> (Stat)ExileDB.Stats().get(x)).collect(Collectors.toList());
        }
        return new ArrayList<Stat>(this.map2.values());
    }

    public Stat get() {
        if (this.map.size() > 1) {
            throw new RuntimeException("Using simple .get() for stat that isn't just a single stat!");
        }
        return this.get(EmptyAccessor.INSTANCE);
    }
}

