/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases;

import com.robertx22.mine_and_slash.database.data.spells.spell_classes.bases.SpellPredicate;
import com.robertx22.mine_and_slash.mmorpg.ModErrors;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.tags.all.SlotTags;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class SpellPredicates {
    private static Predicate<LivingEntity> SHOOTABLE_PRED = x -> {
        try {
            GearData wep = Load.Unit((Entity)x).equipmentCache.getWeapon();
            return wep != null && wep.gear != null && wep.gear.GetBaseGearType().getTags().contains(SlotTags.ranged_weapon);
        }
        catch (Exception e) {
            ModErrors.print(e);
            return false;
        }
    };
    private static Predicate<LivingEntity> MELEE_PRED = x -> {
        try {
            GearData wep = Load.Unit((Entity)x).equipmentCache.getWeapon();
            return wep != null && wep.gear != null && wep.gear.GetBaseGearType().getTags().contains(SlotTags.melee_weapon);
        }
        catch (Exception e) {
            ModErrors.print(e);
            return false;
        }
    };
    private static Predicate<LivingEntity> MAGE_PRED = x -> {
        try {
            GearData wep = Load.Unit((Entity)x).equipmentCache.getWeapon();
            return wep != null && wep.gear != null && wep.gear.GetBaseGearType().getTags().contains(SlotTags.mage_weapon);
        }
        catch (Exception e) {
            ModErrors.print(e);
            return false;
        }
    };
    private static Predicate<LivingEntity> NON_MAGE_PRED = x -> !MAGE_PRED.test((LivingEntity)x);
    private static Predicate<LivingEntity> ANY = x -> true;
    public static SpellPredicate REQUIRE_SHOOTABLE = new SpellPredicate(SHOOTABLE_PRED, Chats.REQUIRE_RANGED.locName().m_130940_(ChatFormatting.GREEN));
    public static SpellPredicate REQUIRE_MAGE_WEAPON = new SpellPredicate(MAGE_PRED, Chats.REQUIRE_MAGE.locName().m_130940_(ChatFormatting.GREEN));
    public static SpellPredicate REQUIRE_MELEE = new SpellPredicate(MELEE_PRED, Chats.REQUIRE_MELEE.locName().m_130940_(ChatFormatting.GOLD));
    public static SpellPredicate ANY_ITEM = new SpellPredicate(ANY, Chats.ANY_ITEM.locName().m_130940_(ChatFormatting.GOLD));
    public static SpellPredicate NON_MAGE_WEAPON = new SpellPredicate(NON_MAGE_PRED, Chats.NONE_MAGE.locName().m_130940_(ChatFormatting.GOLD));
}

