/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.spell_classes;

import com.robertx22.mine_and_slash.database.data.spells.components.EntityActivation;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.PositionSource;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SpellCtx {
    public static String ON_ENTITY_ATTACKED = "on_entity_attacked";
    public Level world;
    public Entity sourceEntity;
    public LivingEntity caster;
    public LivingEntity target;
    public final EntityActivation activation;
    public CalculatedSpellData calculatedSpellData;
    private PositionSource positionSource = PositionSource.SOURCE_ENTITY;

    public SpellCtx setSourceEntity(Entity en) {
        this.sourceEntity = en;
        return this;
    }

    public Entity getPositionEntity() {
        return this.positionSource.get(this);
    }

    public SpellCtx setPositionSource(PositionSource s) {
        this.positionSource = s;
        return this;
    }

    public BlockPos getBlockPos() {
        return this.positionSource.get(this).m_20183_();
    }

    public Vec3 getPos() {
        return this.positionSource.get(this).m_20182_();
    }

    public GearItemData getWeapon() {
        GearData stack = Load.Unit((Entity)this.caster).equipmentCache.getWeapon();
        if (stack != null && stack.gear != null) {
            return stack.gear;
        }
        return null;
    }

    private SpellCtx(EntityActivation act, Entity sourceEntity, LivingEntity caster, LivingEntity target, CalculatedSpellData calculatedSpellData) {
        this.sourceEntity = sourceEntity;
        this.caster = caster;
        this.target = target;
        this.calculatedSpellData = calculatedSpellData;
        this.world = caster.m_9236_();
        this.activation = act;
    }

    public static SpellCtx onCast(LivingEntity caster, CalculatedSpellData data) {
        Objects.requireNonNull(caster);
        Objects.requireNonNull(data);
        return new SpellCtx(EntityActivation.ON_CAST, (Entity)caster, caster, caster, data);
    }

    public static SpellCtx onHit(LivingEntity caster, Entity sourceEntity, LivingEntity target, CalculatedSpellData data) {
        Objects.requireNonNull(caster);
        Objects.requireNonNull(sourceEntity);
        Objects.requireNonNull(data);
        Load.Unit((Entity)caster).onSpellHitTarget(sourceEntity, target);
        return new SpellCtx(EntityActivation.ON_HIT, sourceEntity, caster, target, data).setPositionSource(PositionSource.TARGET);
    }

    public static SpellCtx onEntityHit(SpellCtx ctx, LivingEntity target) {
        Objects.requireNonNull(ctx);
        Objects.requireNonNull(target);
        return new SpellCtx(EntityActivation.PER_ENTITY_HIT, ctx.sourceEntity, ctx.caster, target, ctx.calculatedSpellData).setPositionSource(PositionSource.TARGET);
    }

    public static SpellCtx onEntityBasicAttacked(LivingEntity caster, CalculatedSpellData data, LivingEntity target) {
        Objects.requireNonNull(caster);
        Objects.requireNonNull(target);
        return new SpellCtx(EntityActivation.ENTITY_BASIC_ATTACKED, (Entity)target, caster, target, data).setPositionSource(PositionSource.TARGET);
    }

    public static SpellCtx onExpire(LivingEntity caster, Entity sourceEntity, CalculatedSpellData data) {
        Objects.requireNonNull(caster);
        Objects.requireNonNull(sourceEntity);
        Objects.requireNonNull(data);
        LivingEntity target = sourceEntity instanceof LivingEntity ? (LivingEntity)sourceEntity : null;
        return new SpellCtx(EntityActivation.ON_EXPIRE, sourceEntity, caster, target, data);
    }

    public static SpellCtx onTick(LivingEntity caster, Entity sourceEntity, CalculatedSpellData data) {
        Objects.requireNonNull(caster);
        Objects.requireNonNull(sourceEntity);
        Objects.requireNonNull(data);
        LivingEntity target = sourceEntity instanceof LivingEntity ? (LivingEntity)sourceEntity : null;
        return new SpellCtx(EntityActivation.ON_TICK, sourceEntity, caster, target, data);
    }
}

