/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.selectors;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.BaseTargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class AoeSelector
extends BaseTargetSelector {
    public AoeSelector() {
        super(Arrays.asList(MapField.RADIUS, MapField.SELECTION_TYPE, MapField.ENTITY_PREDICATE));
    }

    @Override
    public List<LivingEntity> get(SpellCtx ctx, LivingEntity caster, LivingEntity target, Vec3 pos, MapHolder data) {
        AllyOrEnemy predicate = data.getEntityPredicate();
        Double radius = data.get(MapField.RADIUS);
        radius = radius * (double)ctx.calculatedSpellData.data.getNumber((String)EventData.AREA_MULTI, (float)1.0f).number;
        Double chance = data.getOrDefault(MapField.SELECTION_CHANCE, 100.0);
        EntityFinder.Setup<LivingEntity> finder = EntityFinder.start((Entity)caster, LivingEntity.class, pos).finder(EntityFinder.SelectionType.RADIUS).searchFor(predicate).height(data.getOrDefault(MapField.HEIGHT, radius)).radius(radius);
        if (chance < 100.0) {
            return finder.build().stream().filter(x -> AoeSelector.canHit(ctx.getPos(), (Entity)x) && RandomUtils.roll((double)chance)).collect(Collectors.toList());
        }
        List<LivingEntity> list = finder.build();
        list.removeIf(x -> !AoeSelector.canHit(ctx.getPos(), (Entity)x));
        return list;
    }

    public static boolean canHit(Vec3 pos, Entity en) {
        int i;
        float perc = Explosion.m_46064_((Vec3)pos, (Entity)en);
        if ((double)perc >= 0.4) {
            return true;
        }
        int height = 2;
        if (en.m_9236_().m_45547_(new ClipContext(pos, pos.m_82520_(0.0, (double)height, 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS) {
            for (i = 1; i <= height; ++i) {
                if (!((double)Explosion.m_46064_((Vec3)pos.m_82520_(0.0, (double)i, 0.0), (Entity)en) >= 0.4)) continue;
                return true;
            }
        }
        if (en.m_9236_().m_45547_(new ClipContext(pos, pos.m_82520_(0.0, (double)(-height), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_6662_() == HitResult.Type.MISS) {
            for (i = -1; i >= -height; --i) {
                if (!((double)Explosion.m_46064_((Vec3)pos.m_82520_(0.0, (double)i, 0.0), (Entity)en) >= 0.4)) continue;
                return true;
            }
        }
        return false;
    }

    public MapHolder enemiesInRadius(Double radius) {
        return this.create(radius, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.enemies);
    }

    public MapHolder alliesInRadius(Double radius) {
        return this.create(radius, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.allies);
    }

    public MapHolder create(Double radius, EntityFinder.SelectionType type, AllyOrEnemy pred) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.RADIUS, radius);
        d.put(MapField.SELECTION_TYPE, type.name());
        d.put(MapField.ENTITY_PREDICATE, pred.name());
        this.validate(d);
        return d;
    }

    public String GUID() {
        return "aoe";
    }
}

