/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.entities.StationaryFallingBlockEntity;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class SummonBlockAction
extends SpellAction {
    static int SEARCH = 10;

    public SummonBlockAction() {
        super(Arrays.asList(MapField.ENTITY_NAME, MapField.BLOCK));
    }

    static boolean isSolid(Level level, BlockPos pos) {
        return level.m_8055_(pos).m_280296_();
    }

    static float getRandomOffset(MapHolder data, MapField<Double> f) {
        float off = data.getOrDefault(f, 0.0).floatValue();
        if (off != 0.0f) {
            int te = (int)(off * 100.0f);
            float num = (float)RandomUtils.RandomRange((int)0, (int)te) / 100.0f;
            return RandomUtils.roll((int)50) ? num : -num;
        }
        return 0.0f;
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (ctx.world.f_46443_) {
            return;
        }
        MyPosition pos = new MyPosition(ctx.getBlockPos());
        float yoff = SummonBlockAction.getRandomOffset(data, MapField.RANDOM_Y_OFFSET);
        float xoff = SummonBlockAction.getRandomOffset(data, MapField.RANDOM_X_OFFSET);
        float zoff = SummonBlockAction.getRandomOffset(data, MapField.RANDOM_Z_OFFSET);
        pos = new MyPosition(pos.m_7096_() + (double)xoff, pos.m_7098_() + (double)data.getOrDefault(MapField.HEIGHT, 0.0).intValue() + (double)yoff, pos.m_7094_() + (double)zoff);
        boolean found = true;
        if (data.getOrDefault(MapField.FIND_NEAREST_SURFACE, true).booleanValue()) {
            int times;
            found = false;
            int minHeight = ctx.world.m_141937_();
            for (times = 0; !found && pos.m_7098_() > (double)minHeight && SEARCH > times; ++times) {
                if (!SummonBlockAction.isSolid(ctx.world, pos.asBlockPos()) && SummonBlockAction.isSolid(ctx.world, pos.asBlockPos().m_7495_())) {
                    found = true;
                    continue;
                }
                pos = new MyPosition(pos.f_82479_, pos.f_82480_ - 1.0, pos.f_82481_);
            }
            if (!found) {
                pos = new MyPosition(ctx.getBlockPos());
                for (times = 0; !found && pos.m_7098_() < (double)ctx.world.m_151558_() && SEARCH > times; ++times) {
                    if (!SummonBlockAction.isSolid(ctx.world, pos.asBlockPos()) && SummonBlockAction.isSolid(ctx.world, pos.asBlockPos().m_7495_())) {
                        found = true;
                        continue;
                    }
                    pos = new MyPosition(pos.f_82479_, pos.f_82480_ + 1.0, pos.f_82481_);
                }
            }
        }
        Block block = data.getBlock();
        Objects.requireNonNull(block);
        if (found) {
            StationaryFallingBlockEntity be = new StationaryFallingBlockEntity(ctx.world, pos.asBlockPos(), block.m_49966_());
            be.m_20088_().m_135381_(StationaryFallingBlockEntity.IS_FALLING, (Object)data.getOrDefault(MapField.IS_BLOCK_FALLING, false));
            SpellUtils.initSpellEntity((Entity)be, ctx.caster, ctx.calculatedSpellData, data);
            ctx.world.m_7967_((Entity)be);
        }
    }

    public MapHolder create(Block block, Double lifespan) {
        MapHolder c = new MapHolder();
        c.put(MapField.BLOCK, VanillaUTIL.REGISTRY.blocks().getKey((Object)block).toString());
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.LIFESPAN_TICKS, lifespan);
        c.type = this.GUID();
        return c;
    }

    public String GUID() {
        return "summon_block";
    }
}

