/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SummonAtSightAction
extends SpellAction {
    public SummonAtSightAction() {
        super(Arrays.asList(MapField.ENTITY_NAME, MapField.PROJECTILE_ENTITY, MapField.LIFESPAN_TICKS, MapField.HEIGHT));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        if (ctx.world.f_46443_) {
            return;
        }
        Optional projectile = EntityType.m_20632_((String)data.get(MapField.PROJECTILE_ENTITY));
        Double distance = data.getOrDefault(MapField.DISTANCE, 10.0);
        Double height = data.getOrDefault(MapField.HEIGHT, 10.0);
        HitResult ray = ctx.getPositionEntity().m_19907_(distance.doubleValue(), 0.0f, false);
        Vec3 pos = ray.m_82450_();
        Entity en = ((EntityType)projectile.get()).m_20615_(ctx.world);
        SpellUtils.initSpellEntity(en, ctx.caster, ctx.calculatedSpellData, data);
        int yadd = 0;
        BlockPos bpos = new BlockPos((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
        for (int i = 0; i < height.intValue() && (i == 0 || ctx.world.m_8055_(bpos.m_6630_(i)).m_60795_()); ++i) {
            ++yadd;
        }
        en.m_6034_(pos.f_82479_, pos.f_82480_ + (double)yadd, pos.f_82481_);
        ctx.caster.m_9236_().m_7967_(en);
    }

    public MapHolder create(EntityType type, Double lifespan, Double height) {
        MapHolder c = new MapHolder();
        c.put(MapField.LIFESPAN_TICKS, lifespan);
        c.put(MapField.GRAVITY, false);
        c.put(MapField.ENTITY_NAME, Spell.DEFAULT_EN_NAME);
        c.put(MapField.HEIGHT, height);
        c.put(MapField.PROJECTILE_ENTITY, EntityType.m_20613_((EntityType)type).toString());
        c.type = this.GUID();
        this.validate(c);
        return c;
    }

    public String GUID() {
        return "summon_at_sight";
    }
}

