/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.DashUtils;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.world.entity.LivingEntity;

public class PushAction
extends SpellAction {
    public PushAction() {
        super(Arrays.asList(MapField.PUSH_STRENGTH, MapField.PUSH_WAY));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        float str = data.get(MapField.PUSH_STRENGTH).floatValue();
        DashUtils.Way way = data.getPushWay();
        targets.forEach(x -> DashUtils.dash(x, str, way));
    }

    public MapHolder create(Double str, DashUtils.Way way) {
        MapHolder d = new MapHolder();
        d.type = this.GUID();
        d.put(MapField.PUSH_STRENGTH, str);
        d.put(MapField.PUSH_WAY, way.name());
        return d;
    }

    public String GUID() {
        return "push";
    }
}

