/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components.actions;

import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.ExileEffectAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;

public class PotionAction
extends SpellAction {
    public PotionAction() {
        super(Arrays.asList(MapField.POTION_ID, MapField.POTION_ACTION, MapField.POTION_DURATION));
    }

    @Override
    public void tryActivate(Collection<LivingEntity> targets, SpellCtx ctx, MapHolder data) {
        try {
            ExileEffectAction.GiveOrTake action = data.getPotionAction();
            for (LivingEntity t : targets) {
                if (action == ExileEffectAction.GiveOrTake.GIVE_STACKS) {
                    MobEffect potion = data.getPotion();
                    int dura = data.get(MapField.POTION_DURATION).intValue();
                    int str = data.getOrDefault(MapField.POTION_STRENGTH, 1.0).intValue();
                    t.m_7292_(new MobEffectInstance(potion, dura, str));
                    continue;
                }
                if (action == ExileEffectAction.GiveOrTake.REMOVE_STACKS) {
                    MobEffect potion = data.getPotion();
                    t.m_21195_(potion);
                    continue;
                }
                if (action != ExileEffectAction.GiveOrTake.REMOVE_NEGATIVE) continue;
                int count = data.getOrDefault(MapField.COUNT, 1.0).intValue();
                for (int i = 0; i < count; ++i) {
                    List opt = t.m_21220_().stream().filter(x -> x.m_19544_().m_19483_() == MobEffectCategory.HARMFUL).collect(Collectors.toList());
                    if (opt.isEmpty()) continue;
                    t.m_21195_(((MobEffectInstance)opt.get(0)).m_19544_());
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public MapHolder createGive(MobEffect effect, Double duration) {
        MapHolder dmg = new MapHolder();
        dmg.type = this.GUID();
        dmg.put(MapField.COUNT, 1.0);
        dmg.put(MapField.POTION_DURATION, duration);
        dmg.put(MapField.POTION_ACTION, ExileEffectAction.GiveOrTake.GIVE_STACKS.name());
        dmg.put(MapField.POTION_ID, BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString());
        return dmg;
    }

    public MapHolder removeNegative(Double count) {
        MapHolder dmg = new MapHolder();
        dmg.type = this.GUID();
        dmg.put(MapField.COUNT, count);
        dmg.put(MapField.POTION_ACTION, ExileEffectAction.GiveOrTake.REMOVE_NEGATIVE.name());
        return dmg;
    }

    public MapHolder createRemove(MobEffect effect) {
        MapHolder dmg = new MapHolder();
        dmg.type = this.GUID();
        dmg.put(MapField.COUNT, 1.0);
        dmg.put(MapField.POTION_ACTION, ExileEffectAction.GiveOrTake.REMOVE_STACKS.name());
        dmg.put(MapField.POTION_ID, BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString());
        return dmg;
    }

    public String GUID() {
        return "potion";
    }
}

