/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.spells.components;

import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import com.robertx22.mine_and_slash.database.data.spells.components.MapHolder;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.AoeSelector;
import com.robertx22.mine_and_slash.database.data.spells.entities.CalculatedSpellData;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellCtx;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.SpellUtils;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.joml.Math;
import org.joml.Vector3f;

public class ProjectileCastHelper {
    LivingEntity caster;
    public boolean silent = false;
    public float apart = 3.0f;
    public float shootSpeed = 1.0f;
    public int projectilesAmount = 1;
    public float randomSpreadDegrees = 0.0f;
    public boolean gravity = true;
    EntityType projectile;
    CalculatedSpellData data;
    MapHolder holder;
    Vec3 pos;
    public CastType castType = CastType.SPREAD_OUT_IN_RADIUS;
    public float pitch;
    public float yaw;
    public boolean fallDown = false;
    public boolean targetEnemy = false;
    SpellCtx ctx;

    public ProjectileCastHelper(SpellCtx ctx, Vec3 pos, MapHolder holder, LivingEntity caster, EntityType projectile, CalculatedSpellData data) {
        this.ctx = ctx;
        this.projectile = projectile;
        this.caster = caster;
        this.data = data;
        this.holder = holder;
        this.pos = pos;
        this.pitch = caster.m_146909_();
        this.yaw = caster.m_146908_();
    }

    public void cast() {
        if (this.data.data.getBoolean(EventData.BARRAGE)) {
            this.castType = CastType.SPREAD_OUT_HORIZONTAL;
        }
        Level world = this.caster.m_9236_();
        for (int i = 0; i < this.projectilesAmount; ++i) {
            float addYaw = 0.0f;
            Vec3 posAdd = new Vec3(0.0, 0.0, 0.0);
            if (this.projectilesAmount > 1) {
                float offset = (float)i - (float)(this.projectilesAmount - 1) / 2.0f;
                if (this.castType == CastType.SPREAD_OUT_IN_RADIUS) {
                    addYaw = offset * this.apart / (float)this.projectilesAmount;
                } else if (this.castType == CastType.SPREAD_OUT_HORIZONTAL) {
                    posAdd = this.getSideVelocity((Entity)this.caster).m_82542_((double)offset, (double)offset, (double)offset);
                }
            }
            float randomYawOffset = 0.0f;
            float randomPitchOffset = 0.0f;
            if (this.randomSpreadDegrees > 0.0f) {
                randomYawOffset = (float)((Math.random() * 2.0 - 1.0) * (double)this.randomSpreadDegrees);
                randomPitchOffset = (float)((Math.random() * 2.0 - 1.0) * (double)this.randomSpreadDegrees);
            }
            Vec3 vec31 = this.caster.m_20289_(1.0f);
            float totalPitch = this.pitch + randomPitchOffset;
            float totalYaw = this.yaw + addYaw + randomYawOffset;
            float pitchRad = Math.toRadians((float)totalPitch);
            float yawRad = Math.toRadians((float)totalYaw);
            float x = -Mth.m_14031_((float)yawRad) * Mth.m_14089_((float)pitchRad);
            float y = -Mth.m_14031_((float)pitchRad);
            float z = Mth.m_14089_((float)yawRad) * Mth.m_14089_((float)pitchRad);
            Vector3f finalVel = new Vector3f(x, y, z);
            AbstractArrow en = (AbstractArrow)this.projectile.m_20615_(world);
            SpellUtils.shootProjectile(this.pos.m_82549_(posAdd), en, this.ctx.getPositionEntity(), this.shootSpeed, this.pitch + randomPitchOffset, this.yaw + addYaw + randomYawOffset);
            SpellUtils.initSpellEntity((Entity)en, this.caster, this.data, this.holder);
            en.m_6686_((double)finalVel.x, (double)finalVel.y, (double)finalVel.z, this.shootSpeed, 1.0f);
            if (this.fallDown) {
                en.m_20334_(0.0, -1.0, 0.0);
            }
            en.m_20225_(this.silent);
            if (this.targetEnemy) {
                BlockPos pos = en.m_20183_();
                EntityFinder.Setup<LivingEntity> finder = EntityFinder.start((Entity)this.caster, LivingEntity.class, pos).finder(EntityFinder.SelectionType.RADIUS).searchFor(AllyOrEnemy.enemies).predicate(e -> AoeSelector.canHit(this.ctx.getPos(), (Entity)e)).radius(15.0);
                LivingEntity target = finder.getClosest();
                if (target == null) continue;
                Vec3 vel = ProjectileCastHelper.positionToVelocity(new MyPosition(en.m_20182_()), new MyPosition(target.m_146892_()));
                vel = vel.m_82542_((double)this.shootSpeed, (double)this.shootSpeed, (double)this.shootSpeed);
                en.m_6686_(vel.f_82479_, vel.f_82480_, vel.f_82481_, 1.0f, 0.0f);
                this.caster.m_9236_().m_7967_((Entity)en);
                break;
            }
            this.caster.m_9236_().m_7967_((Entity)en);
        }
    }

    public static Vec3 positionToVelocity(MyPosition current, MyPosition destination) {
        return destination.m_82546_((Vec3)current).m_82541_();
    }

    public Vec3 getSideVelocity(Entity shooter) {
        float yaw = shooter.m_146908_() * ((float)java.lang.Math.PI / 180);
        return new Vec3((double)Math.cos((float)yaw), 0.0, (double)Math.sin((float)yaw));
    }

    public static enum CastType {
        SPREAD_OUT_IN_RADIUS,
        SPREAD_OUT_HORIZONTAL;

    }
}

