/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.runewords;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RunewordRecipe
implements IAutoLocName {
    private static final String RUNES_PATH = "runes/";
    public String id;
    public String name;
    public List<String> runes = new ArrayList<String>();
    public List<String> slots = new ArrayList<String>();
    public List<StatMod> stats = new ArrayList<StatMod>();

    public List<ItemStack> toMaterialsStackForJei() {
        return this.runes.stream().map(this::toRuneStackForJei).collect(Collectors.toList());
    }

    private ItemStack toRuneStackForJei(String runeId) {
        return new ItemStack((ItemLike)VanillaUTIL.REGISTRY.items().get(new ResourceLocation("mmorpg", RUNES_PATH + runeId)), 1);
    }

    public List<List<ItemStack>> toResultSlotsForJei() {
        HashMap slotToItemsMap = new HashMap();
        this.slots.forEach(slot -> slotToItemsMap.put(slot, new ArrayList()));
        VanillaUTIL.REGISTRY.items().getAll().forEach(item -> {
            ItemStack itemStack = new ItemStack((ItemLike)item);
            GearSlot gearSlot = GearSlot.getSlotOf(itemStack);
            if (gearSlot == null) {
                return;
            }
            for (String slot : this.slots) {
                if (!gearSlot.id.equals(slot)) continue;
                ((List)slotToItemsMap.get(slot)).add(itemStack);
            }
        });
        return new ArrayList<List<ItemStack>>(slotToItemsMap.values());
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Rune_Words;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.runeword." + this.id;
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }

    public String GUID() {
        return this.id;
    }
}

