/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.runewords;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.vanilla_mc.items.gemrunes.RuneItem;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class RuneWord
implements IAutoGson<RuneWord>,
JsonExileRegistry<RuneWord>,
IAutoLocName {
    public static RuneWord SERIALIZER = new RuneWord();
    public String id = "";
    public transient String name = "";
    public List<StatMod> stats = new ArrayList<StatMod>();
    public List<String> runes = new ArrayList<String>();
    public List<String> slots = new ArrayList<String>();

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.RUNEWORDS;
    }

    public String GUID() {
        return this.id;
    }

    public boolean isEmpty() {
        return ExileDB.RuneWords().getDefault() != null && ((RuneWord)ExileDB.RuneWords().getDefault()).GUID().equals(this.GUID());
    }

    public Class<RuneWord> getClassForSerialization() {
        return RuneWord.class;
    }

    public static String join(Iterator<?> iterator, String separator) {
        if (separator == null) {
            separator = "";
        }
        StringBuilder buf = new StringBuilder(256);
        while (iterator.hasNext()) {
            buf.append(iterator.next());
            if (!iterator.hasNext()) continue;
            buf.append(separator);
        }
        return buf.toString();
    }

    public boolean hasMatchingRunesToCreate(GearItemData gear) {
        List list = gear.sockets.getSocketed().stream().map(x -> x.g).collect(Collectors.toList());
        String reqString = this.getRunesString();
        String testString = RuneWord.join(list.listIterator(), "");
        return testString.contains(reqString);
    }

    public String getRunesString() {
        return RuneWord.join(this.runes.listIterator(), "");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isRuneItem(String id, ItemStack stack) {
        Item item = stack.m_41720_();
        if (!(item instanceof RuneItem)) return false;
        RuneItem rune = (RuneItem)item;
        if (!rune.type.id.equals(id)) return false;
        return true;
    }

    public boolean canApplyOnItem(ItemStack stack) {
        return this.slots.stream().anyMatch(e -> GearSlot.isItemOfThisSlot((GearSlot)ExileDB.GearSlots().get(e), stack));
    }

    public boolean canApplyOnItem(GearItemData gear) {
        return this.slots.stream().anyMatch(x -> gear.GetBaseGearType().gear_slot.equals(x));
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Rune_Words;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.runeword." + this.id;
    }

    @Override
    public String locNameForLangFile() {
        return this.name;
    }
}

