/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.rarities;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.data.omen.OmenDifficulty;
import com.robertx22.mine_and_slash.database.data.rarities.BaseRarity;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarityType;
import com.robertx22.mine_and_slash.database.data.rarities.IGearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.uncommon.interfaces.data_items.VanillaRarities;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientTextureUtils;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Rarity;

public final class GearRarity
extends BaseRarity
implements IGearRarity,
IAutoGson<GearRarity> {
    public static GearRarity SERIALIZER = new GearRarity();
    public int favor_needed = 0;
    public float favor_loot_multi = 1.0f;
    public int favor_per_hour = 0;
    public OmenDifficulty omens = new OmenDifficulty(new MinMax(1, 1), new MinMax(1, 1), new MinMax(1, 1), new MinMax(1, 1), new MinMax(1, 1), 1.0f);
    public int affix_rarity_weight = 1000;
    public GearRarityType type = GearRarityType.NORMAL;
    public LootableGearTier lootable_gear_tier = LootableGearTier.LOW;
    public int item_model_data_num = -1;
    public MinMax base_stat_percents = new MinMax(0, 100);
    public MinMax stat_percents = new MinMax(0, 0);
    public Potential pot = new Potential(100);
    public int min_affixes = 0;
    public MinMax sockets = new MinMax(0, 2);
    public int item_tier = -1;
    public int max_runes = 1;
    public int max_gems = 10;
    public float item_tier_power;
    public int min_lvl = 0;
    public String min_map_rarity_to_drop = "common";
    public float item_value_multi;
    public boolean announce_in_chat = false;
    public boolean can_have_runewords = false;
    public boolean is_unique_item = false;
    public MinMax map_tiers = new MinMax(0, 100);
    public boolean drops_uber_frags = false;
    public int map_lives = 5;
    public float map_xp_multi = 1.0f;
    public int map_resist_req = 0;
    transient ResourceLocation glintFull;
    transient ResourceLocation glintCircle;
    transient ResourceLocation glintTexBorder;

    public GearRarity edit(Consumer<GearRarity> co) {
        co.accept(this);
        return this;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.GEAR_RARITY;
    }

    public float getFavorGainEverySecond() {
        if (this.favor_loot_multi > 0.0f) {
            return (float)this.favor_per_hour / 3600.0f;
        }
        return 0.0f;
    }

    public Rarity getVanillaRarity() {
        return VanillaRarities.MAP.getOrDefault(this.GUID(), Rarity.COMMON);
    }

    public MinMax getPossibleMapTiers() {
        return this.map_tiers;
    }

    public MutableComponent coloredName() {
        return this.locName().m_130940_(this.textFormatting());
    }

    public Class<GearRarity> getClassForSerialization() {
        return GearRarity.class;
    }

    public ResourceLocation getGlintTextureFull() {
        if (this.glintFull == null) {
            ResourceLocation tex = SlashRef.id("textures/gui/rarity_glint/full/" + this.GUID() + ".png");
            this.glintFull = ClientTextureUtils.textureExists(tex) ? tex : SlashRef.id("textures/gui/rarity_glint/full/default.png");
        }
        return this.glintFull;
    }

    public ResourceLocation getGlintTextureCircle() {
        if (this.glintCircle == null) {
            ResourceLocation tex = SlashRef.id("textures/gui/rarity_glint/circle/" + this.GUID() + ".png");
            this.glintCircle = ClientTextureUtils.textureExists(tex) ? tex : SlashRef.id("textures/gui/rarity_glint/circle/default.png");
        }
        return this.glintCircle;
    }

    public ResourceLocation getGlintTextureBorder() {
        if (this.glintTexBorder == null) {
            ResourceLocation tex = SlashRef.id("textures/gui/rarity_glint/border/" + this.GUID() + ".png");
            this.glintTexBorder = ClientTextureUtils.textureExists(tex) ? tex : SlashRef.id("textures/gui/rarity_glint/border/default.png");
        }
        return this.glintTexBorder;
    }

    public ResourceLocation getMapIconTexture() {
        return SlashRef.guiId("map/rarity/" + this.GUID());
    }

    public boolean isHigherThan(GearRarity other) {
        return this.item_tier > other.item_tier;
    }

    @Override
    public float valueMulti() {
        return this.item_value_multi;
    }

    @Override
    public float itemTierPower() {
        return this.item_tier_power;
    }

    @Override
    public int getAffixAmount() {
        return this.min_affixes;
    }

    public boolean hasHigherRarity() {
        return ExileDB.GearRarities().isRegistered(this.higher_rar);
    }

    public GearRarity getHigherRarity() {
        if (this.higher_rar.isEmpty()) {
            return null;
        }
        return (GearRarity)ExileDB.GearRarities().get(this.higher_rar);
    }

    public Optional<GearRarity> getLowerRarity() {
        List lower = ExileDB.GearRarities().getFilterWrapped((Predicate<GearRarity>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getLowerRarity$0(com.robertx22.mine_and_slash.database.data.rarities.GearRarity ), (Lcom/robertx22/mine_and_slash/database/data/rarities/GearRarity;)Z)((GearRarity)this)).list;
        if (!lower.isEmpty()) {
            return Optional.of((GearRarity)lower.get(0));
        }
        return Optional.ofNullable(null);
    }

    private /* synthetic */ boolean lambda$getLowerRarity$0(GearRarity x) {
        return x.getHigherRarity() == this;
    }

    public static enum LootableGearTier {
        LOW(0),
        MID(1),
        HIGH(2);

        int tier;

        private LootableGearTier(int tier) {
            this.tier = tier;
        }
    }

    public static class Potential {
        public int total;

        public Potential(int total) {
            this.total = total;
        }
    }
}

