/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession.screen;

import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe;
import com.robertx22.mine_and_slash.database.data.profession.StationSyncData;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.data.profession.items.ProfTierMatItem;
import com.robertx22.mine_and_slash.database.data.profession.screen.CraftButton;
import com.robertx22.mine_and_slash.database.data.profession.screen.CraftingStationMenu;
import com.robertx22.mine_and_slash.database.data.profession.screen.ItemButton;
import com.robertx22.mine_and_slash.database.data.profession.screen.LockButton;
import com.robertx22.mine_and_slash.database.data.profession.screen.PrimaryMatInfoButton;
import com.robertx22.mine_and_slash.database.data.profession.screen.RecipeButton;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.RarityItems;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.RarityStoneItem;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public abstract class CraftingStationScreen
extends AbstractContainerScreen<CraftingStationMenu> {
    public ResourceLocation BACKGROUND_LOCATION = new ResourceLocation("mmorpg", "textures/gui/crafting_table2.png");
    Profession prof;
    public PrimaryMatInfoButton.InfoData primaryTier;
    public PrimaryMatInfoButton.InfoData primaryRar = new PrimaryMatInfoButton.InfoData(Words.PRIMARY_RARITY_MAT, (Item)RarityItems.RARITY_STONE.get("common").get(), RarityItems.RARITY_STONE.values().stream().map(x -> (Item)x.get()).toList());
    int ticks = 0;
    String possible = "";

    public CraftingStationScreen(String prof, CraftingStationMenu pMenu, Inventory pPlayerInventory, Component txt) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, (Component)((Profession)ExileDB.Professions().get(prof)).locName());
        this.prof = (Profession)ExileDB.Professions().get(prof);
        this.f_97726_ = 176;
        this.f_97727_ = 182;
        this.f_97728_ = this.getGuiLeft() + this.f_97726_ / 2;
        this.f_97729_ = -15;
    }

    protected void m_181908_() {
        super.m_181908_();
        ++this.ticks;
        if (this.ticks % 20 == 0) {
            this.refreshPossibleRecipes();
        }
    }

    public StationSyncData getSyncedData() {
        return StationSyncData.SYNCED_DATA;
    }

    protected void m_7856_() {
        super.m_7856_();
        if (!this.prof.GUID().equals(Professions.SALVAGING)) {
            this.m_142416_((GuiEventListener)new LockButton(this.f_97735_ + 79, this.f_97736_ + 33, this));
        }
        this.m_142416_((GuiEventListener)new CraftButton(this.f_97735_ + 79, this.f_97736_ + 51, this));
        if (this.primaryTier != null) {
            this.m_142416_((GuiEventListener)new PrimaryMatInfoButton(this.primaryTier, this.f_97735_ + 15, this.f_97736_ + 75));
            this.m_142416_((GuiEventListener)new PrimaryMatInfoButton(this.primaryRar, this.f_97735_ + 35, this.f_97736_ + 75));
        }
        this.refreshPossibleRecipes();
        this.refreshRequiredMats();
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.m_280273_(pGuiGraphics);
        super.m_88315_(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.m_280072_(pGuiGraphics, pMouseX, pMouseY);
    }

    public void refreshRequiredMats() {
        StationSyncData data = this.getSyncedData();
        if (data.recipe_locked.booleanValue() && !data.recipe.isEmpty()) {
            ProfessionRecipe recipe = (ProfessionRecipe)ExileDB.Recipes().get(data.recipe);
            this.refreshRequiredMats(recipe);
        }
    }

    public void refreshRequiredMats(ProfessionRecipe recipe) {
        this.m_6702_().removeIf(x -> x instanceof ItemButton);
        this.f_169369_.removeIf(x -> x instanceof ItemButton);
        int xoff = 0;
        int yoff = 0;
        int spacing = 18;
        for (ItemStack stack : recipe.getMaterials()) {
            ItemButton button = new ItemButton(stack, this.f_97735_ + 64 + xoff, this.f_97736_ + 75 + yoff);
            ArrayList<Component> tip = new ArrayList<Component>();
            tip.add((Component)Component.m_237113_((String)(UNICODE.CUBE + " ")).m_7220_((Component)Itemtips.RECIPE_MATERIAL.locName()).m_130946_(" " + UNICODE.CUBE).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
            tip.add((Component)Component.m_237119_());
            button.extraText = tip;
            this.m_142416_((GuiEventListener)button);
            xoff += spacing;
        }
    }

    public void refreshPossibleRecipes() {
        List<ProfessionRecipe> all = this.getPossibleRecipes();
        Object str = "";
        for (String s : all.stream().sorted(Comparator.comparing(x -> x.GUID())).map(x -> x.GUID()).collect(Collectors.toList())) {
            str = (String)str + s;
        }
        if (!this.possible.equals(str)) {
            this.possible = str;
            this.m_6702_().removeIf(x -> x instanceof RecipeButton);
            this.f_169369_.removeIf(x -> x instanceof RecipeButton);
            int xoff = 0;
            int yoff = 0;
            int spacing = RecipeButton.XS + 2;
            for (ProfessionRecipe recipe : all) {
                this.m_142416_((GuiEventListener)new RecipeButton(this, recipe, this.f_97735_ + xoff, this.f_97736_ - 20 - yoff));
                if ((xoff += spacing) <= spacing * 2) continue;
                xoff = 0;
                yoff += spacing;
            }
        }
    }

    public List<ProfessionRecipe> getPossibleRecipes() {
        RarityStoneItem v1 = null;
        ProfTierMatItem v2 = null;
        for (Slot slot : ((CraftingStationMenu)this.f_97732_).matslots) {
            ProfTierMatItem mat;
            Item item = slot.m_7993_().m_41720_();
            if (item instanceof RarityStoneItem) {
                RarityStoneItem r;
                v1 = r = (RarityStoneItem)item;
            }
            if (!((item = slot.m_7993_().m_41720_()) instanceof ProfTierMatItem)) continue;
            v2 = mat = (ProfTierMatItem)item;
        }
        HashSet<ProfessionRecipe> recipes = new HashSet<ProfessionRecipe>(ExileDB.Recipes().getFilterWrapped((Predicate<ProfessionRecipe>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPossibleRecipes$7(com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe ), (Lcom/robertx22/mine_and_slash/database/data/profession/ProfessionRecipe;)Z)((CraftingStationScreen)this)).list);
        if (v1 != null && v2 != null) {
            for (ProfessionRecipe rec : ExileDB.Recipes().getFilterWrapped((Predicate<ProfessionRecipe>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPossibleRecipes$8(com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe ), (Lcom/robertx22/mine_and_slash/database/data/profession/ProfessionRecipe;)Z)((CraftingStationScreen)this)).list) {
                if (rec.isMadeWithPrimaryMats(v1, v2)) continue;
                recipes.removeIf(x -> x.GUID().equals(rec.GUID()));
            }
        } else {
            recipes = new HashSet();
        }
        recipes.addAll(ExileDB.Recipes().getFilterWrapped((Predicate<ProfessionRecipe>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$getPossibleRecipes$10(com.robertx22.mine_and_slash.database.data.profession.ProfessionRecipe ), (Lcom/robertx22/mine_and_slash/database/data/profession/ProfessionRecipe;)Z)((CraftingStationScreen)this)).list);
        return recipes.stream().toList();
    }

    protected void m_280003_(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY) {
        pGuiGraphics.m_280614_(this.f_96547_, this.f_96539_, this.f_97728_ - this.f_96547_.m_92852_((FormattedText)this.f_96539_) / 2, this.f_97729_, ChatFormatting.YELLOW.m_126665_().intValue(), false);
    }

    protected void m_7286_(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        int i = (this.f_96543_ - this.f_97726_) / 2;
        int j = (this.f_96544_ - this.f_97727_) / 2;
        pGuiGraphics.m_280218_(this.BACKGROUND_LOCATION, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    private /* synthetic */ boolean lambda$getPossibleRecipes$10(ProfessionRecipe x) {
        return x.profession.equals(this.prof.GUID()) && x.canCraft((List<ItemStack>)((CraftingStationMenu)this.f_97732_).m_38927_()).can;
    }

    private /* synthetic */ boolean lambda$getPossibleRecipes$8(ProfessionRecipe x) {
        return x.profession.equals(this.prof.GUID());
    }

    private /* synthetic */ boolean lambda$getPossibleRecipes$7(ProfessionRecipe x) {
        return x.profession.equals(this.prof.GUID());
    }
}

