/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession.items;

import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.ItemModelManager;
import com.robertx22.mine_and_slash.aoe_data.datapacks.models.ModelHelper;
import com.robertx22.mine_and_slash.capability.player.data.PlayerBuffData;
import com.robertx22.mine_and_slash.database.data.profession.ICreativeTabTiered;
import com.robertx22.mine_and_slash.database.data.profession.LeveledItem;
import com.robertx22.mine_and_slash.database.data.profession.buffs.StatBuff;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.gui.texts.ExileTooltips;
import com.robertx22.mine_and_slash.gui.texts.textblocks.OperationTipBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.RequirementBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.affixdatablocks.SimpleItemStatBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.dropblocks.ProfessionDropSourceBlock;
import com.robertx22.mine_and_slash.gui.texts.textblocks.usableitemblocks.UsageBlock;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.mmorpg.registers.common.items.CraftedRarity;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IRarityItem;
import com.robertx22.mine_and_slash.uncommon.localization.Formatter;
import com.robertx22.mine_and_slash.uncommon.localization.Itemtips;
import com.robertx22.mine_and_slash.vanilla_mc.items.misc.AutoItem;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class CraftedBuffFoodItem
extends AutoItem
implements IRarityItem,
ICreativeTabTiered {
    public String buff_id;
    PlayerBuffData.Type type;
    CraftedRarity rar;

    public CraftedBuffFoodItem(PlayerBuffData.Type type, String buff_id, CraftedRarity rar) {
        super(CraftedBuffFoodItem.getProp(type));
        this.buff_id = buff_id;
        this.rar = rar;
        this.type = type;
    }

    static Item.Properties getProp(PlayerBuffData.Type type) {
        if (type.isFood()) {
            return new Item.Properties().m_41489_(new FoodProperties.Builder().m_38760_(6).m_38758_(5.0f).m_38757_().m_38767_());
        }
        return new Item.Properties();
    }

    @Override
    public void generateModel(ItemModelManager manager) {
        new ModelHelper(this, ModelHelper.Type.GENERATED, SlashRef.id("item/" + this.type.id + "/" + this.buff_id).toString()).generate();
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        return ItemUtils.m_150959_((Level)pLevel, (Player)pPlayer, (InteractionHand)pUsedHand);
    }

    public ItemStack m_5922_(ItemStack stack, Level pLevel, LivingEntity pLivingEntity) {
        Player p;
        boolean did;
        if (!pLevel.f_46443_ && pLivingEntity instanceof Player && (did = Load.player((Player)p).buff.tryAdd(p = (Player)pLivingEntity, this.getBuff(), LeveledItem.getLevel(stack), this.rar.getPercent(), this.type, this.getTicksDuration()))) {
            pLivingEntity.m_7292_(new MobEffectInstance(this.type.effect.get(), this.getTicksDuration()));
            stack.m_41774_(1);
            return stack;
        }
        return stack;
    }

    public int getTicksDuration() {
        return this.type.durationTicks;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        if (this.type.isFood()) {
            return UseAnim.EAT;
        }
        return UseAnim.DRINK;
    }

    public int m_8105_(ItemStack pStack) {
        return 32;
    }

    public StatBuff getBuff() {
        return (StatBuff)ExileDB.StatBuffs().get(this.buff_id);
    }

    public Component m_7626_(ItemStack stack) {
        return Formatter.BUFF_CONSUMPTIONS_NAME.locName(this.rar.getRarity().locName(), this.getBuff().mods.get(0).GetStat().locName(), this.type.locName()).m_130940_(this.rar.getRarity().textFormatting());
    }

    public void m_7373_(ItemStack stack, @Nullable Level pLevel, List<Component> list, TooltipFlag pIsAdvanced) {
        try {
            StatBuff buff = this.getBuff();
            int lvl = LeveledItem.getLevel(stack);
            ArrayList<MutableComponent> info = new ArrayList<MutableComponent>();
            info.add(Component.m_237113_((String)(UNICODE.STAR + " ")).m_7220_((Component)Itemtips.BUFF_CONSUMABLE_TYPE.locName(this.type.locName().m_130940_(ChatFormatting.YELLOW))).m_130940_(ChatFormatting.AQUA));
            info.addAll(ExileTooltipUtils.splitLongText((MutableComponent)Itemtips.BUFF_CONSUMABLE_INFO.locName().m_130940_(ChatFormatting.AQUA)));
            info.add(Component.m_237113_((String)(UNICODE.ROTATED_CUBE + " ")).m_7220_((Component)Itemtips.BUFF_CONSUMABLE_DURATION_MINUTES.locName(Component.m_237113_((String)("" + this.getTicksDuration() / 20 / 60)).m_130940_(ChatFormatting.YELLOW))).m_130940_(ChatFormatting.GREEN));
            list.addAll(new ExileTooltips().accept(new SimpleItemStatBlock(new StatRangeInfo(ModRange.always(this.rar.getPercent()))).accept((Component)Itemtips.BUFF_TIP.locName(), buff.getStats(lvl, this.rar.getPercent()))).accept(new RequirementBlock(lvl)).accept(new OperationTipBlock().setAlt()).accept(new ProfessionDropSourceBlock(this.type.profession)).accept(new UsageBlock(info)).release());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Misc;
    }

    @Override
    public String locNameLangFileGUID() {
        return "";
    }

    @Override
    public String locNameForLangFile() {
        return "";
    }

    public String GUID() {
        return "";
    }

    @Override
    public Item getThis() {
        return this;
    }

    @Override
    public GearRarity getItemRarity(ItemStack stack) {
        return this.rar.getRarity();
    }
}

