/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.profession.LeveledItem;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.stat.ProfExp;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipUtils;
import com.robertx22.temp.SkillItemTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class ProfessionRecipe
implements JsonExileRegistry<ProfessionRecipe>,
IAutoGson<ProfessionRecipe> {
    public static ProfessionRecipe SERIALIZER = new ProfessionRecipe();
    public String id = "";
    public String profession = "";
    public boolean set_tier_nbt = true;
    private List<CraftingMaterial> mats = new ArrayList<CraftingMaterial>();
    public String result = "";
    private int result_num = 1;
    private int exp = 100;
    public int tier = 0;

    public int getLevelRequirement() {
        return this.getTier().levelRange.getMinLevel();
    }

    public List<Component> getTooltipJEI() {
        ArrayList<Component> list = new ArrayList<Component>();
        Profession prof = (Profession)ExileDB.Professions().get(this.profession);
        list.add((Component)prof.locName().m_130946_(" ").m_7220_((Component)TooltipUtils.level(this.getLevelRequirement())));
        return list;
    }

    public SkillItemTier getTier() {
        return SkillItemTier.of(this.tier);
    }

    public int getExpReward(Player player, int skilLvl, List<ItemStack> mats) {
        int expLvl = MathHelper.clamp(skilLvl, this.getTier().levelRange.getMinLevel(), this.getTier().levelRange.getMaxLevel());
        int req = this.getTier().levelRange.getMinLevel();
        RecipeDifficulty diff = RecipeDifficulty.get(skilLvl, req);
        float expbonusmulti = Load.Unit((Entity)player).getUnit().getCalculatedStat(new ProfExp(this.profession)).getMultiplier();
        return (int)((float)expLvl * diff.xpMulti * (float)this.exp * expbonusmulti);
    }

    public ItemStack toResultStackForJei() {
        ItemStack stack = new ItemStack((ItemLike)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.result)), this.result_num);
        if (this.set_tier_nbt) {
            LeveledItem.setTier(stack, this.tier);
        }
        return stack;
    }

    public void spendMaterials(List<ItemStack> stacks) {
        block0: for (CraftingMaterial mat : this.mats) {
            for (ItemStack stack : stacks) {
                if (!mat.matches(stack)) continue;
                mat.spend(stack);
                continue block0;
            }
        }
    }

    public List<CraftingMaterial> getMissingMaterials(List<ItemStack> stacks) {
        ArrayList<CraftingMaterial> list = new ArrayList<CraftingMaterial>();
        for (CraftingMaterial mat : this.mats) {
            boolean has = false;
            for (ItemStack stack : stacks) {
                if (!mat.matches(stack)) continue;
                has = true;
            }
            if (has) continue;
            list.add(mat);
        }
        return list;
    }

    public boolean isMadeWithPrimaryMats(Item tier, Item rar) {
        ItemStack v1 = new ItemStack((ItemLike)tier, 64);
        ItemStack v2 = new ItemStack((ItemLike)rar, 64);
        return this.mats.stream().anyMatch(x -> x.matches(v1)) && this.mats.stream().anyMatch(x -> x.matches(v2));
    }

    public ExplainedResult canCraft(List<ItemStack> stacks) {
        MutableComponent msg = Words.CRAFT_FAILED.locName();
        boolean fail = false;
        for (CraftingMaterial mat : this.mats) {
            boolean nope = true;
            FailReason reason = FailReason.NO_ITEM;
            int have = 0;
            for (ItemStack stack : stacks) {
                if (!mat.matches(stack)) continue;
                nope = false;
            }
            if (nope) {
                for (ItemStack stack : stacks) {
                    if (!mat.hasAnyCount(stack)) continue;
                    have = stack.m_41613_();
                    reason = FailReason.NOT_ENOUGH_OF_ITEM;
                }
            }
            if (!stacks.stream().noneMatch(x -> mat.matches((ItemStack)x))) continue;
            fail = true;
            msg.m_7220_((Component)reason.word.locName(mat.toStackForJei().m_41611_(), mat.num, have));
        }
        if (fail) {
            return ExplainedResult.failure((Component)msg);
        }
        return ExplainedResult.success();
    }

    public List<ItemStack> craft(Player p, List<ItemStack> stacks) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        ItemStack stack = new ItemStack((ItemLike)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.result)), this.result_num);
        if (this.set_tier_nbt) {
            LeveledItem.setTier(stack, this.tier);
        }
        list.add(stack);
        RecipeDifficulty diff = RecipeDifficulty.get(Load.player((Player)p).professions.getLevel(this.profession), this.getLevelRequirement());
        if (RandomUtils.roll((int)diff.doubleDropChance)) {
            if (stack.m_41741_() > 1) {
                stack.m_41764_(stack.m_41613_() * 2);
            } else {
                list.add(stack.m_41777_());
            }
        }
        return list;
    }

    public List<ItemStack> getMaterials() {
        return this.mats.stream().map(x -> x.toStackForJei()).collect(Collectors.toList());
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.RECIPE;
    }

    public Class<ProfessionRecipe> getClassForSerialization() {
        return ProfessionRecipe.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    public static enum RecipeDifficulty {
        EASY(ChatFormatting.WHITE, 30, Words.Easy, 0.25f, 25),
        MEDIUM(ChatFormatting.GREEN, 20, Words.Medium, 0.5f, 10),
        HARD(ChatFormatting.YELLOW, 10, Words.Hard, 0.75f, 5),
        VERY_HARD(ChatFormatting.RED, 0, Words.VERY_HARD, 1.0f, 0);

        public ChatFormatting color;
        public Words word;
        public float xpMulti;
        public int doubleDropChance;
        public int masteryLvls;

        private RecipeDifficulty(ChatFormatting color, int mastery, Words word, float xpMulti, int doubleDropChance) {
            this.color = color;
            this.masteryLvls = mastery;
            this.word = word;
            this.xpMulti = xpMulti;
            this.doubleDropChance = doubleDropChance;
        }

        public static RecipeDifficulty get(int skilllvl, int recipelvl) {
            if (recipelvl > skilllvl) {
                return VERY_HARD;
            }
            int diff = Math.abs(skilllvl - recipelvl);
            return Arrays.stream(RecipeDifficulty.values()).filter(x -> x.masteryLvls >= diff).max(Comparator.comparing(x -> -x.doubleDropChance)).orElse(VERY_HARD);
        }
    }

    public static class CraftingMaterial {
        public String id = "";
        public int num = 1;
        public Type type = Type.ITEM;

        public boolean matches(ItemStack stack) {
            if (this.type == Type.ITEM) {
                return VanillaUTIL.REGISTRY.items().getKey((Object)stack.m_41720_()).toString().equals(this.id) && stack.m_41613_() >= this.num;
            }
            return false;
        }

        public boolean hasAnyCount(ItemStack stack) {
            if (this.type == Type.ITEM) {
                return VanillaUTIL.REGISTRY.items().getKey((Object)stack.m_41720_()).toString().equals(this.id);
            }
            return false;
        }

        public ItemStack toStackForJei() {
            return new ItemStack((ItemLike)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.id)), this.num);
        }

        public void spend(ItemStack stack) {
            stack.m_41774_(this.num);
        }

        public static CraftingMaterial item(String id, int num) {
            CraftingMaterial c = new CraftingMaterial();
            c.id = id;
            c.num = num;
            return c;
        }

        public static enum Type {
            ITEM,
            TAG,
            FOOD,
            MEAT;

        }
    }

    public static enum FailReason {
        NO_ITEM(Words.NO_ITEM_FOUND),
        NOT_ENOUGH_OF_ITEM(Words.NOT_ENOUGH_ITEM_FOUND);

        public Words word;

        private FailReason(Words word) {
            this.word = word;
        }
    }

    public static class TierBuilder {
        List<Consumer<Data>> actions = new ArrayList<Consumer<Data>>();

        public static TierBuilder of(Function<SkillItemTier, Item> item, String proff, int num) {
            TierBuilder b = new TierBuilder();
            b.actions.add(data -> {
                ResourceLocation id = VanillaUTIL.REGISTRY.items().getKey((Object)((Item)item.apply(data.tier)));
                data.recipe.id = id.m_135815_().replaceAll("/", "_") + data.tier.tier;
                data.recipe.result = id.toString();
                data.recipe.profession = proff;
                data.recipe.result_num = num;
                data.recipe.tier = data.tier.tier;
            });
            return b;
        }

        public TierBuilder exp(int xp) {
            this.actions.add(x -> {
                x.recipe.exp = xp;
            });
            return this;
        }

        public TierBuilder onlyOnTier(Function<SkillItemTier, ItemStack> tier) {
            this.actions.add(data -> {
                ItemStack stack = (ItemStack)tier.apply(data.tier);
                if (!stack.m_41619_()) {
                    ResourceLocation id = VanillaUTIL.REGISTRY.items().getKey((Object)stack.m_41720_());
                    if (stack.m_41613_() > stack.m_41741_()) {
                        throw new RuntimeException(id.toString() + " has more than max stack size");
                    }
                    data.recipe.mats.add(CraftingMaterial.item(id.toString(), stack.m_41613_()));
                }
            });
            return this;
        }

        public TierBuilder onTierOrAbove(SkillItemTier tier, Item item, int num) {
            this.actions.add(data -> {
                if (data.tier.tier >= tier.tier) {
                    ResourceLocation id = VanillaUTIL.REGISTRY.items().getKey((Object)item);
                    data.recipe.mats.add(CraftingMaterial.item(id.toString(), num));
                }
            });
            return this;
        }

        public TierBuilder custom(Consumer<Data> con) {
            this.actions.add(con);
            return this;
        }

        public void buildEachTier() {
            for (SkillItemTier tier : SkillItemTier.values()) {
                ProfessionRecipe r = new ProfessionRecipe();
                Data data = new Data(tier, r);
                for (Consumer<Data> action : this.actions) {
                    action.accept(data);
                }
                r.addToSerializables((ExileRegistrationInfo)MMORPG.SERIAZABLE_REGISTRATION_INFO);
            }
        }
    }

    public static class Data {
        public SkillItemTier tier;
        public ProfessionRecipe recipe;

        public Data(SkillItemTier tier, ProfessionRecipe recipe) {
            this.tier = tier;
            this.recipe = recipe;
        }
    }
}

