/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession;

import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.mine_and_slash.database.data.profession.PlayerUTIL;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.all.Professions;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.mmorpg.ForgeEvents;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.event.entity.player.ItemFishedEvent;

public class ProfessionEvents {
    public static void init() {
        ExileEvents.PLAYER_MINE_ORE.register((EventConsumer)new EventConsumer<ExileEvents.PlayerMineOreEvent>(){

            public void accept(ExileEvents.PlayerMineOreEvent e) {
                Player p = e.player;
                if (p != null && !p.m_9236_().f_46443_) {
                    if (PlayerUTIL.isFake(p)) {
                        return;
                    }
                    List<ItemStack> drops = ((Profession)ExileDB.Professions().get(Professions.MINING)).onMineGetBonusDrops(p, Arrays.asList(new ItemStack[0]), e.state);
                    e.itemsToAddToDrop.addAll(drops);
                }
            }
        });
        ExileEvents.PLAYER_MINE_FARMABLE.register((EventConsumer)new EventConsumer<ExileEvents.PlayerMineFarmableBlockEvent>(){

            public void accept(ExileEvents.PlayerMineFarmableBlockEvent e) {
                Player p = e.player;
                if (p != null && !p.m_9236_().f_46443_) {
                    if (PlayerUTIL.isFake(p)) {
                        return;
                    }
                    List<ItemStack> drops = ((Profession)ExileDB.Professions().get(Professions.FARMING)).onMineGetBonusDrops(p, e.droppedItems, e.state);
                    e.itemsToAddToDrop.addAll(drops);
                }
            }
        });
        ForgeEvents.registerForgeEvent(ItemFishedEvent.class, x -> {
            Player p = x.getEntity();
            if (p != null && !p.m_9236_().f_46443_) {
                if (PlayerUTIL.isFake(p)) {
                    return;
                }
                List<ItemStack> drops = ((Profession)ExileDB.Professions().get(Professions.FISHING)).onFish(p);
                if (!drops.isEmpty()) {
                    // empty if block
                }
                for (ItemStack drop : drops) {
                    ItemEntity itemEntity = p.m_19983_(drop);
                }
            }
        });
        ForgeEvents.registerForgeEvent(BabyEntitySpawnEvent.class, x -> {
            Player p = x.getCausedByPlayer();
            if (p != null && !p.m_9236_().f_46443_) {
                if (PlayerUTIL.isFake(p)) {
                    return;
                }
                if (x.getChild() != null) {
                    List<ItemStack> drops = ((Profession)ExileDB.Professions().get(Professions.HUSBANDRY)).onBreedAnimal(p, (Entity)x.getChild());
                    for (ItemStack drop : drops) {
                        x.getParentA().m_19983_(drop);
                    }
                }
            }
        });
    }
}

