/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession;

import com.robertx22.mine_and_slash.database.data.profession.ProfessionBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class MergedContainer
extends SimpleContainer
implements WorldlyContainer {
    public List<Inventory> invs;
    public ProfessionBlockEntity pbe;

    public MergedContainer(List<Inventory> invs, ProfessionBlockEntity be) {
        super(MergedContainer.getSize(invs));
        this.invs = invs;
        this.pbe = be;
    }

    static int getSize(List<Inventory> inv) {
        return inv.stream().mapToInt(x -> x.size).sum();
    }

    public boolean addStack(Inventory inv, ItemStack stack) {
        for (int index : this.getIndices(inv.id)) {
            ItemStack current = this.m_8020_(index);
            if (current.m_41619_()) {
                this.m_6836_(index, stack.m_41777_());
                return true;
            }
            if (current.m_41720_() != stack.m_41720_() || !Objects.equals(stack.m_41783_(), current.m_41783_()) || current.m_41613_() + stack.m_41613_() > current.m_41741_()) continue;
            current.m_41764_(current.m_41613_() + stack.m_41613_());
            return true;
        }
        return false;
    }

    public int[] getIndices(String id) {
        int i = 0;
        for (Inventory inv : this.invs) {
            if (!inv.id.equals(id)) {
                i += inv.size;
                continue;
            }
            int[] ar = new int[inv.size];
            for (int x = 0; x < inv.size; ++x) {
                ar[x] = i + x;
            }
            return ar;
        }
        return new int[0];
    }

    public SimpleContainer getInventory(Inventory inv) {
        return new SimpleContainer(this.getAllStacks(inv).toArray(new ItemStack[inv.size]));
    }

    public int getIndex(String id, int num) {
        int i = 0;
        for (Inventory inv : this.invs) {
            if (!inv.id.equals(id)) {
                i += inv.size;
                continue;
            }
            return i += num;
        }
        return i;
    }

    public List<ItemStack> getAllStacks(Inventory inv) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int index : this.getIndices(inv.id)) {
            list.add(this.m_8020_(index));
        }
        return list;
    }

    public ItemStack getStack(Inventory inv, int num) {
        return this.m_8020_(this.getIndex(inv.id, num));
    }

    public void setStack(ItemStack stack, Inventory inv, int num) {
        this.m_6836_(this.getIndex(inv.id, num), stack);
    }

    public int[] m_7071_(Direction pSide) {
        Optional<Inventory> inv = this.invs.stream().filter(x -> x.hopperface == pSide).findAny();
        if (inv.isPresent() && inv != null) {
            return this.getIndices(inv.get().id);
        }
        return new int[0];
    }

    public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
        if (pDirection != Direction.UP) {
            return false;
        }
        return this.pbe.onTryInsertItem(pItemStack);
    }

    public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
        return pDirection == Direction.DOWN;
    }

    public static class Inventory {
        public String id;
        public int size;
        public Direction hopperface;

        public Inventory(String id, int size, Direction hopperface) {
            this.id = id;
            this.size = size;
            this.hopperface = hopperface;
        }
    }
}

