/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.profession;

import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.capability.player.data.PlayerConfigData;
import com.robertx22.mine_and_slash.database.data.game_balance_config.GameBalanceConfig;
import com.robertx22.mine_and_slash.database.data.profession.Profession;
import com.robertx22.mine_and_slash.database.data.profession.stat.ProfExp;
import com.robertx22.mine_and_slash.loot.LootModifier;
import com.robertx22.mine_and_slash.loot.LootModifierEnum;
import com.robertx22.mine_and_slash.loot.LootModifiersList;
import com.robertx22.mine_and_slash.saveclasses.prof_tool.ProfessionToolData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Gui;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.LevelUtils;
import com.robertx22.temp.SkillItemTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class ExpSources {
    public static String REQ_GROWTH_STAGE = "req_growth_stage";
    public HashMap<Integer, List<ExpSource>> map = new HashMap();
    public ExpData default_xp = new ExpData(50, 0, Arrays.asList(new String[0]));

    public void add(SkillItemTier tier, Type type, String id, int exp, String ... req) {
        if (!this.map.containsKey(tier.tier)) {
            this.map.put(tier.tier, new ArrayList());
        }
        this.map.get(tier.tier).add(new ExpSource(type, exp, id, Arrays.asList(req)));
    }

    public ExpData getData(Object obj) {
        for (SkillItemTier value : SkillItemTier.values()) {
            Optional<ExpSource> opt;
            if (!this.map.containsKey(value.tier) || !(opt = this.map.get(value.tier).stream().filter(x -> x.matches(obj)).findAny()).isPresent()) continue;
            return new ExpData(opt.get().exp, value.tier, opt.get().req);
        }
        return null;
    }

    public ExpData getDefaultExp() {
        return this.default_xp;
    }

    public ExpData exp(int exp, int tier) {
        return new ExpData(exp, tier, new ArrayList<String>());
    }

    public class ExpData {
        public int exp;
        public int tier;
        public List<String> req = new ArrayList<String>();

        public ExpData(int exp, int tier, List<String> req) {
            this.exp = exp;
            this.tier = tier;
            this.req = req;
        }

        public void levelTool(Player p, Profession pro, int xpgiven) {
            ItemStack stack;
            if (!pro.tool_tag.isEmpty() && ProfessionToolData.isCorrectTool(pro, stack = p.m_21205_())) {
                ProfessionToolData data = null;
                if (StackSaving.TOOL.has(stack)) {
                    data = (ProfessionToolData)StackSaving.TOOL.loadFrom(stack);
                } else {
                    data = new ProfessionToolData();
                    data.lvl = 1;
                    data.prof = pro.GUID();
                }
                data.addExp(p, stack, xpgiven);
                StackSaving.TOOL.saveTo(stack, (Object)data);
            }
        }

        public void giveExp(Player p, Profession pro) {
            int tierDiff;
            LootModifiersList lootMods = new LootModifiersList();
            int proflvl = Load.player((Player)p).professions.getLevel(pro.GUID());
            int fx = LevelUtils.scaleExpReward(this.exp, Load.player((Player)p).professions.getLevel(pro.id));
            float lowRecipeLvlPenalty = 1.0f;
            SkillItemTier playerTier = SkillItemTier.fromLevel(proflvl);
            SkillItemTier itemTier = SkillItemTier.fromLevel(this.getLevelOfMastery());
            if (playerTier.tier > itemTier.tier && (lowRecipeLvlPenalty = (float)((double)lowRecipeLvlPenalty - (double)(tierDiff = playerTier.tier - itemTier.tier) * GameBalanceConfig.get().PROFESSION_EXP_PENALTY_PER_LOWER_LEVEL)) < 0.0f) {
                lowRecipeLvlPenalty = 0.0f;
            }
            lootMods.add(new LootModifier(LootModifierEnum.PROFESSION_BONUS_STAT, Load.Unit((Entity)p).getUnit().getCalculatedStat(new ProfExp(pro.id)).getMultiplier()));
            lootMods.add(new LootModifier(LootModifierEnum.LOW_LEVEL_RECIPE_PENALTY, lowRecipeLvlPenalty));
            for (LootModifier mod : lootMods.all) {
                fx = (int)((float)fx * mod.multi);
            }
            this.levelTool(p, pro, fx);
            Load.player((Player)p).professions.addExp(p, pro.GUID(), fx);
            if (Load.player((Player)p).config.isConfigEnabled(PlayerConfigData.Config.PROFESSION_MESSAGES)) {
                MutableComponent hovertext = lootMods.getHoverText();
                HoverEvent hover = new HoverEvent(HoverEvent.Action.f_130831_, (Object)hovertext);
                MutableComponent text = Gui.PROF_EXP_GAIN_CHAT.locName(fx, pro.locName());
                text.m_6270_(Style.f_131099_.m_131144_(hover)).m_130940_(ChatFormatting.GREEN);
                p.m_213846_((Component)text);
            }
        }

        public int getLevelOfMastery() {
            return SkillItemTier.of((int)this.tier).levelRange.getMinLevel();
        }

        public float getLootChanceMulti(Player p, Profession pro) {
            float lvlmulti = MathHelper.clamp((float)Load.player((Player)p).professions.getLevel(pro.GUID()) / (float)this.getLevelOfMastery(), 0.0f, 1.0f);
            return (float)(this.exp + 50) / 100.0f * lvlmulti;
        }
    }

    public static class ExpSource {
        public Type type;
        public int exp;
        public String id;
        public List<String> req;

        public ExpSource(Type type, int exp, String id, List<String> req) {
            this.type = type;
            this.exp = exp;
            this.id = id;
            this.req = req;
        }

        public boolean matches(Object obj) {
            if (this.type == Type.BLOCK_TAG && obj instanceof TagKey) {
                TagKey in = (TagKey)obj;
                return in.f_203868_().equals((Object)new ResourceLocation(this.id));
            }
            if (this.type == Type.BLOCK && obj instanceof Block) {
                Block in = (Block)obj;
                return VanillaUTIL.REGISTRY.blocks().getKey((Object)in).equals((Object)new ResourceLocation(this.id));
            }
            if (this.type == Type.FARM_ITEM && obj instanceof Item) {
                Item in = (Item)obj;
                return VanillaUTIL.REGISTRY.items().getKey((Object)in).equals((Object)new ResourceLocation(this.id));
            }
            if (this.type == Type.ENTITY && obj instanceof EntityType) {
                EntityType in = (EntityType)obj;
                return ForgeRegistries.ENTITY_TYPES.getKey((Object)in).equals((Object)new ResourceLocation(this.id));
            }
            return false;
        }
    }

    public static enum Type {
        BLOCK,
        FARM_ITEM,
        ENTITY,
        CRAFTING,
        BLOCK_TAG;

    }
}

