/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.perks;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.data.perks.PerkStatus;
import com.robertx22.mine_and_slash.database.data.spell_school.SpellSchool;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.LearnSpellStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.mmorpg.SlashRef;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.ModRange;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellSchoolsData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientTextureUtils;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.TooltipStatsAligner;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class Perk
implements JsonExileRegistry<Perk>,
IAutoGson<Perk>,
IAutoLocName {
    public static Perk SERIALIZER = new Perk();
    public PerkType type;
    public String id;
    public String icon = "";
    public String one_kind = null;
    public transient String locname = "";
    public boolean is_entry = false;
    public int max_lvls = 1;
    public List<OptScaleExactStat> stats = new ArrayList<OptScaleExactStat>();
    transient ResourceLocation cachedIcon = null;

    public SpellSchoolsData.PointType getPointType() {
        return this.isSpell() ? SpellSchoolsData.PointType.SPELL : SpellSchoolsData.PointType.PASSIVE;
    }

    public int getMaxLevel() {
        return this.max_lvls;
    }

    public boolean isSpell() {
        return this.stats.size() > 0 && this.stats.get(0).getStat() instanceof LearnSpellStat;
    }

    public Spell getSpell() {
        Stat stat = this.stats.get(0).getStat();
        if (stat instanceof LearnSpellStat) {
            LearnSpellStat a = (LearnSpellStat)stat;
            return a.spell;
        }
        return null;
    }

    public boolean isPassive() {
        return !this.isSpell() && this.max_lvls > 1;
    }

    public Optional<SpellSchool> getSpellSchool() {
        Optional<SpellSchool> opt = ExileDB.SpellSchools().getList().stream().filter(x -> x.perks.containsKey(this.GUID())).findFirst();
        return opt;
    }

    public ResourceLocation getIcon() {
        if (this.cachedIcon == null) {
            ResourceLocation id = new ResourceLocation(this.icon);
            this.cachedIcon = ClientTextureUtils.textureExists(id) ? id : Stat.MISSING_ICON;
        }
        return this.cachedIcon;
    }

    public int Weight() {
        return 1000;
    }

    public List<Component> GetTooltipString(StatRangeInfo info) {
        ArrayList<Component> list = new ArrayList<Component>();
        try {
            Stat finalLvl2;
            if (this.type != PerkType.STAT && this.type != PerkType.MAJOR && this.type != PerkType.SPECIAL) {
                list.add((Component)this.locName().m_130940_(this.type.format));
            }
            if (this.type == PerkType.MAJOR) {
                list.add((Component)this.locName().m_130940_(ChatFormatting.DARK_PURPLE));
            }
            if (this.isPassive()) {
                int lvl = Load.player((Player)info.player).ascClass.getLevel(this.GUID());
                if (lvl < 1) {
                    lvl = 1;
                }
                int finalLvl2 = lvl;
                Stream<ExactStatData> scaled = this.stats.stream().map(x -> {
                    ExactStatData d = x.toExactStat(1);
                    d.percentIncrease = (finalLvl2 - 1) * 100;
                    d.increaseByAddedPercent();
                    return d;
                });
                scaled.forEach(x -> list.addAll(x.GetTooltipString()));
            } else {
                ArrayList<Component> preList = new ArrayList<Component>();
                this.stats.forEach(x -> preList.addAll(x.GetTooltipString(info)));
                list.addAll(new TooltipStatsAligner(preList).buildNewTooltipsStats());
            }
            if (this.one_kind != null) {
                list.add((Component)Chats.ONLY_ONE_OF_TYPE.locName().m_130940_(ChatFormatting.GREEN));
                list.add((Component)Component.m_237115_((String)("mmorpg.one_of_a_kind." + this.one_kind)).m_130940_(ChatFormatting.GREEN));
            }
            if (this.type == PerkType.MAJOR) {
                list.add((Component)Words.GAME_CHANGER.locName().m_130940_(ChatFormatting.RED));
            }
            if (this.stats.size() > 0 && (finalLvl2 = this.stats.get(0).getStat()) instanceof LearnSpellStat) {
                LearnSpellStat spell = (LearnSpellStat)finalLvl2;
                SpellCastingData.InsertedSpell data = Load.player((Player)ClientOnly.getPlayer()).spellCastingData.getSpellData(spell.spell.GUID());
                if (data.rank > 0) {
                    list.addAll(data.getData().getTooltip(info.player));
                } else {
                    list.addAll(spell.spell.GetTooltipString(new StatRangeInfo(ModRange.alwaysMax())));
                }
            }
            if (!(this.stats.get(0).getStat() instanceof LearnSpellStat)) {
                list.add((Component)Words.PressAltForStatInfo.locName().m_130940_(ChatFormatting.BLUE));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.Talents;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.talent." + this.id;
    }

    @Override
    public String locNameForLangFile() {
        return this.locname;
    }

    public PerkType getType() {
        return this.type;
    }

    public Class<Perk> getClassForSerialization() {
        return Perk.class;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.PERK;
    }

    public String GUID() {
        return this.id;
    }

    public static enum PerkType {
        STAT("stat", 24, 16, 4, ChatFormatting.WHITE),
        SPECIAL("special", 28, 16, 6, ChatFormatting.LIGHT_PURPLE),
        MAJOR("major", 33, 16, 9, ChatFormatting.RED),
        START("start", 28, 16, 6, ChatFormatting.YELLOW),
        ASC("asc", 56, 32, 14, ChatFormatting.GOLD);

        String id;
        public int size;
        public int iconSize;
        public int off;
        public ChatFormatting format;
        public ResourceLocation yes;
        public ResourceLocation no;
        public ResourceLocation yesColor = SlashRef.guiId("skill_tree/indic/yes");
        public ResourceLocation canColor = SlashRef.guiId("skill_tree/indic/can");
        public ResourceLocation noColor = SlashRef.guiId("skill_tree/indic/no");

        private PerkType(String id, int size, int iconSize, int off, ChatFormatting format) {
            this.id = id;
            this.size = size;
            this.iconSize = iconSize;
            this.format = format;
            this.off = off;
            this.yes = SlashRef.guiId("skill_tree/borders/" + id + "_on");
            this.no = SlashRef.guiId("skill_tree/borders/" + id + "_off");
        }

        public ResourceLocation getColorTexture(PerkStatus s) {
            if (s == PerkStatus.BLOCKED) {
                return this.noColor;
            }
            if (s == PerkStatus.POSSIBLE) {
                return this.canColor;
            }
            if (s == PerkStatus.CONNECTED) {
                return this.yesColor;
            }
            return null;
        }

        public ResourceLocation getBorderTexture(PerkStatus status) {
            if (status == PerkStatus.CONNECTED) {
                return this.yes;
            }
            return this.no;
        }

        public float getOffset() {
            return (float)(this.size - this.iconSize) * 0.5f + 0.5f;
        }
    }

    public static enum Connection {
        LINKED,
        BLOCKED,
        POSSIBLE;

    }
}

