/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.omen;

import com.robertx22.mine_and_slash.database.data.gear_slots.GearSlot;
import com.robertx22.mine_and_slash.database.data.omen.Omen;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarityType;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.saveclasses.unit.GearData;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class OmenData {
    public String id = "";
    public int lvl = 1;
    public String rar = "common";
    public HashMap<GearRarityType, Integer> rarities = new HashMap();
    public List<OmenSlotReq> slot_req = new ArrayList<OmenSlotReq>();
    public List<AffixData> aff = new ArrayList<AffixData>();

    public Omen getOmen() {
        return (Omen)ExileDB.Omens().get(this.id);
    }

    public List<MutableComponent> getReqTooltip() {
        ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
        for (Map.Entry<GearRarityType, Integer> en : this.rarities.entrySet()) {
            all.add(en.getKey().word.locName().m_130946_(": " + en.getValue()).m_130940_(en.getKey().color));
        }
        all.add(Component.m_237119_());
        for (OmenSlotReq req : this.slot_req) {
            MutableComponent rar = req.rtype.word.locName().m_130940_(req.rtype.color);
            all.add(((GearSlot)ExileDB.GearSlots().get(req.slot)).locName().m_130946_(": ").m_130940_(ChatFormatting.GREEN).m_7220_((Component)rar));
        }
        return all;
    }

    public static int getStatPercent(HashMap<GearRarityType, Integer> rarities, List<OmenSlotReq> slot_req, GearRarity rar) {
        int num = 0;
        for (Map.Entry<GearRarityType, Integer> en : rarities.entrySet()) {
            num += en.getValue() * 10;
        }
        num += slot_req.size() * 10;
        num = (int)((float)num * rar.omens.stat_multi);
        return num;
    }

    public int calcPiecesEquipped(Player p) {
        HashMap<GearRarityType, Integer> map = new HashMap<GearRarityType, Integer>();
        for (GearData gear : Load.Unit((Entity)p).equipmentCache.getGear()) {
            if (gear.gear == null) continue;
            GearRarityType type = gear.gear.getRarity().type;
            boolean has = true;
            for (OmenSlotReq slot : this.slot_req) {
                String gearslot = gear.gear.GetBaseGearType().gear_slot;
                if (!slot.slot.equals(gearslot) || type == slot.rtype) continue;
                has = false;
            }
            if (!has || map.getOrDefault((Object)type, 0) >= this.rarities.getOrDefault((Object)type, 0)) continue;
            map.put(type, map.getOrDefault((Object)type, 0) + 1);
        }
        int num = 0;
        for (Map.Entry en : map.entrySet()) {
            num += ((Integer)en.getValue()).intValue();
        }
        return num;
    }

    public GearRarity getRarity() {
        return (GearRarity)ExileDB.GearRarities().get(this.rar);
    }

    public static class OmenSlotReq {
        public String slot;
        public GearRarityType rtype;

        public OmenSlotReq(String slot, GearRarityType rtype) {
            this.slot = slot;
            this.rtype = rtype;
        }
    }
}

