/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data.auto_item;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.helpers.ExileCached;
import com.robertx22.library_of_exile.registry.register_info.ExileRegistrationInfo;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.mine_and_slash.database.data.custom_item.CustomItem;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.ExileStacklessData;
import com.robertx22.mine_and_slash.mmorpg.MMORPG;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class AutoItem
implements JsonExileRegistry<AutoItem>,
IAutoGson<AutoItem> {
    public static AutoItem SERIALIZER = new AutoItem();
    public String id = "";
    public int weight = 1000;
    public String item_id = "";
    public String custom_item_generation = "";
    public static ExileCached<HashMap<Item, List<AutoItem>>> CACHED_MAP = new ExileCached(() -> {
        HashMap map = new HashMap();
        for (AutoItem auto : ExileDB.AutoItems().getList()) {
            Item item = (Item)VanillaUTIL.REGISTRY.items().get(new ResourceLocation(auto.item_id));
            if (item == Items.f_41852_) continue;
            if (!map.containsKey(item)) {
                map.put(item, new ArrayList());
            }
            ((List)map.get(item)).add(auto);
        }
        return map;
    }).clearOnDatabaseChange();

    public static void of(String id, String itemid, String gen) {
        AutoItem b = new AutoItem();
        b.item_id = itemid;
        b.id = id;
        b.custom_item_generation = gen;
        b.addToSerializables((ExileRegistrationInfo)MMORPG.SERIAZABLE_REGISTRATION_INFO);
    }

    public static void tryInsertTo(ItemStack stack, Player p) {
        AutoItem auto;
        if (!StackSaving.GEARS.has(stack) && (!stack.m_41782_() || stack.m_41782_() && !stack.m_41783_().m_128471_("free_souled")) && (auto = AutoItem.getRandom(stack.m_41720_())) != null) {
            stack.m_41784_().m_128379_("free_souled", true);
            ExileStacklessData data = auto.create(p);
            ExileStack ex = ExileStack.of(stack);
            data.apply(ex);
            stack.m_41751_(ex.getStack().m_41783_());
        }
    }

    public ExileStacklessData create(Player p) {
        return ((CustomItem)ExileDB.CustomItemGenerations().get(this.custom_item_generation)).create(p);
    }

    public static AutoItem getRandom(Item item) {
        List list = (List)((HashMap)CACHED_MAP.get()).get(item);
        if (list != null && !list.isEmpty()) {
            AutoItem result = (AutoItem)RandomUtils.weightedRandom((Collection)list);
            return result;
        }
        return null;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.AUTO_ITEM;
    }

    public Class<AutoItem> getClassForSerialization() {
        return AutoItem.class;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return this.weight;
    }
}

