/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.OptScaleExactStat;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityTypeUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityConfig
implements JsonExileRegistry<EntityConfig>,
IAutoGson<EntityConfig> {
    public boolean set_health_damage_override = false;
    public String identifier = "";
    public SpecialMobStats stats = new SpecialMobStats();
    public String set_rar = "";
    public double loot_multi = 1.0;
    public double exp_multi = 1.0;
    public int min_lvl = 1;
    public int max_lvl = 1000000;
    public double dmg_multi = 1.0;
    public double hp_multi = 1.0;
    public double stat_multi = 1.0;

    public EntityConfig() {
    }

    public EntityConfig(String id, float loot) {
        this.identifier = id;
        this.loot_multi = loot;
        this.exp_multi = loot;
    }

    public EntityConfig(EntityType type, float loot) {
        this.identifier = ForgeRegistries.ENTITY_TYPES.getKey((Object)type).toString();
        this.loot_multi = loot;
        this.exp_multi = loot;
    }

    public boolean hasSpecificRarity() {
        return !this.set_rar.isEmpty();
    }

    public String datapackFolder() {
        try {
            if (EntityTypeUtils.EntityClassification.valueOf(this.identifier.toUpperCase(Locale.ROOT)) != null) {
                return "mob_types/";
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (this.identifier.contains(":")) {
            return "specific_mobs/";
        }
        return "all_mobs_in_mod/";
    }

    public Class<EntityConfig> getClassForSerialization() {
        return EntityConfig.class;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.ENTITY_CONFIGS;
    }

    public String GUID() {
        return this.identifier;
    }

    public int Weight() {
        return 100;
    }

    public static class SpecialMobStats {
        public List<OptScaleExactStat> stats = new ArrayList<OptScaleExactStat>();

        public SpecialMobStats(OptScaleExactStat ... stats) {
            this.stats.addAll(Arrays.asList(stats));
        }

        public SpecialMobStats() {
        }

        public SpecialMobStats(SpecialMobStats ... stats) {
            for (SpecialMobStats stat : stats) {
                this.stats.addAll(stat.stats);
            }
        }
    }
}

