/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database.data;

import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.mine_and_slash.database.data.EntityConfig;
import com.robertx22.mine_and_slash.database.data.MinMax;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class DimensionConfig
implements JsonExileRegistry<DimensionConfig>,
IAutoGson<DimensionConfig> {
    public static String DEFAULT_ID = "default";
    public static DimensionConfig EMPTY = new DimensionConfig();
    public String dimension_id = "default";
    public int mob_tier = 0;
    public float all_drop_multi = 1.0f;
    public float exp_multi = 1.0f;
    public float mob_strength_multi = 1.0f;
    public int min_lvl = 1;
    public int max_lvl = Integer.MAX_VALUE;
    public int mob_lvl_per_distance = 100;
    public int min_lvl_area = 100;
    public MinMax secondary_lvl_range = new MinMax(-1, -1);
    public boolean scale_to_nearest_player = false;
    public EntityConfig.SpecialMobStats stats = new EntityConfig.SpecialMobStats();

    public DimensionConfig() {
    }

    public DimensionConfig(int startlvl, String dimension_id) {
        this.min_lvl = startlvl;
        this.dimension_id = dimension_id;
    }

    public DimensionConfig(String dimension_id, int min_lvl, int max_lvl) {
        this.dimension_id = dimension_id;
        this.min_lvl = min_lvl;
        this.max_lvl = max_lvl;
    }

    public static DimensionConfig Overworld() {
        DimensionConfig c = new DimensionConfig(1, "minecraft:overworld");
        c.min_lvl = 1;
        c.max_lvl = 50;
        return c;
    }

    public static DimensionConfig Nether() {
        DimensionConfig d = new DimensionConfig(10, "minecraft:the_nether").setMobTier(2);
        d.min_lvl = 25;
        d.max_lvl = 100;
        return d;
    }

    public static DimensionConfig End() {
        DimensionConfig d = new DimensionConfig(10, "minecraft:the_end").setMobTier(3);
        d.min_lvl = 95;
        d.max_lvl = 100;
        return d;
    }

    public DimensionConfig setDistPerLevel(int dist) {
        this.mob_lvl_per_distance = dist;
        return this;
    }

    public static DimensionConfig DefaultExtra() {
        DimensionConfig config = new DimensionConfig();
        config.min_lvl = 1;
        config.max_lvl = 100;
        config.scale_to_nearest_player = true;
        return config;
    }

    public DimensionConfig setMobTier(int t) {
        this.mob_tier = t;
        return this;
    }

    public boolean hasSecondaryLevelRange() {
        return this.secondary_lvl_range.min > -1 && this.scale_to_nearest_player;
    }

    public MinMax getLevelRangeFor(Player p) {
        if (p != null) {
            int lvl = Load.Unit((Entity)p).getLevel();
            if (this.hasSecondaryLevelRange() && lvl >= this.secondary_lvl_range.min) {
                return this.secondary_lvl_range;
            }
        }
        return new MinMax(this.min_lvl, this.max_lvl);
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.DIMENSION_CONFIGS;
    }

    public String GUID() {
        return this.dimension_id;
    }

    public int Weight() {
        return 1;
    }

    public Class<DimensionConfig> getClassForSerialization() {
        return DimensionConfig.class;
    }
}

