/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.database;

import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.ExactStatData;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_bases.StatRangeInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatInfo;
import com.robertx22.mine_and_slash.saveclasses.item_classes.tooltips.TooltipStatWithContext;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class OptScaleExactStat {
    public static OptScaleExactStat SERIALIZER = new OptScaleExactStat();
    public float v1 = 0.0f;
    public String stat;
    public String type;
    public boolean scale_to_lvl = false;

    private OptScaleExactStat() {
    }

    public OptScaleExactStat(float first, Stat stat) {
        this(first, stat, ModType.FLAT);
    }

    public OptScaleExactStat(float first, Stat stat, ModType type) {
        this.v1 = first;
        this.stat = stat.GUID();
        this.type = type.name();
    }

    public OptScaleExactStat(float first, String stat, ModType type) {
        this.v1 = first;
        this.stat = stat;
        this.type = type.name();
    }

    public String getPerkIdSuffix() {
        if (this.getModType().isFlat()) {
            return "";
        }
        return "_" + this.getModType().id;
    }

    public List<Component> GetTooltipString(StatRangeInfo info, int lvl) {
        Stat stat = this.getStat();
        TooltipStatInfo statInfo = new TooltipStatInfo(this.toExactStat(this.scale_to_lvl ? lvl : 1), -99, info);
        return new ArrayList<MutableComponent>(stat.getTooltipList(new TooltipStatWithContext(statInfo, null, null)));
    }

    public List<MutableComponent> GetTooltipString(StatRangeInfo info) {
        Stat stat = this.getStat();
        TooltipStatInfo statInfo = new TooltipStatInfo(this.toExactStat(this.scale_to_lvl ? info.unitdata.getLevel() : 1), -99, info);
        return new ArrayList<MutableComponent>(stat.getTooltipList(new TooltipStatWithContext(statInfo, null, null)));
    }

    public OptScaleExactStat scale() {
        this.scale_to_lvl = true;
        return this;
    }

    public Stat getStat() {
        return (Stat)ExileDB.Stats().get(this.stat);
    }

    public ModType getModType() {
        return ModType.fromString(this.type);
    }

    public ExactStatData toExactStat(int lvl) {
        Stat stat = (Stat)ExileDB.Stats().get(this.stat);
        return ExactStatData.levelScaled(this.v1, stat, this.getModType(), this.scale_to_lvl ? lvl : 1);
    }

    public ExactStatData ToExactScaleToLevel(int lvl) {
        Stat stat = (Stat)ExileDB.Stats().get(this.stat);
        return ExactStatData.levelScaled(this.v1, stat, this.getModType(), lvl);
    }

    public String getDebugString() {
        return (int)this.v1 + " " + this.getModType().name() + " " + this.getStat().translate();
    }

    public static void combine(List<OptScaleExactStat> list) {
        ArrayList<OptScaleExactStat> combined = new ArrayList<OptScaleExactStat>();
        OptScaleExactStat current = null;
        int i = 0;
        while (!list.isEmpty()) {
            ArrayList<OptScaleExactStat> toRemove = new ArrayList<OptScaleExactStat>();
            for (OptScaleExactStat stat : list) {
                if (i == 0) {
                    toRemove.add(stat);
                    current = new OptScaleExactStat(stat.v1, stat.getStat(), stat.getModType());
                    ++i;
                    continue;
                }
                if (current.stat.equals(stat.stat) && current.type.equals(stat.type) && current.scale_to_lvl == stat.scale_to_lvl) {
                    current.v1 += stat.v1;
                    toRemove.add(stat);
                }
                ++i;
            }
            i = 0;
            combined.add(current);
            toRemove.forEach(n -> list.removeAll(toRemove));
        }
        list.addAll(combined);
    }
}

