/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.config.forge.overlay;

import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayAnchor;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayConfigBuilder;
import com.robertx22.mine_and_slash.config.forge.overlay.OverlayType;
import com.robertx22.mine_and_slash.saveclasses.PointData;
import java.util.Locale;
import net.minecraftforge.common.ForgeConfigSpec;

public class OverlayConfig {
    public ForgeConfigSpec.EnumValue<OverlayAnchor.AttachmentPosition> ANCHOR_X;
    public ForgeConfigSpec.EnumValue<OverlayAnchor.AttachmentPosition> ANCHOR_Y;
    public ForgeConfigSpec.EnumValue<OverlayType> ANCHOR_TARGET;
    public ForgeConfigSpec.IntValue X_OFFSET;
    public ForgeConfigSpec.IntValue Y_OFFSET;

    public OverlayConfig(ForgeConfigSpec.Builder b, OverlayConfigBuilder data) {
        b.comment(data.presetName + " Overlay Preset").push(data.presetName.toLowerCase(Locale.ROOT).replace(" ", "_"));
        this.ANCHOR_TARGET = b.defineEnum("ANCHOR_TO", (Enum)data.anchor);
        this.ANCHOR_X = b.defineEnum("ANCHOR_X", (Enum)data.xAnchor);
        this.ANCHOR_Y = b.defineEnum("ANCHOR_Y", (Enum)data.yAnchor);
        this.X_OFFSET = b.defineInRange("X_OFFSET", data.xoff, -50000, 50000);
        this.Y_OFFSET = b.defineInRange("Y_OFFSET", data.yoff, -50000, 50000);
        b.pop();
    }

    public PointData getPos() {
        OverlayType target = (OverlayType)((Object)this.ANCHOR_TARGET.get());
        int x = ((OverlayAnchor.AttachmentPosition)((Object)this.ANCHOR_X.get())).getAnchorPos((OverlayType)target).x;
        int y = ((OverlayAnchor.AttachmentPosition)((Object)this.ANCHOR_Y.get())).getAnchorPos((OverlayType)target).y;
        if (target != OverlayType.SCREEN) {
            PointData anchorTargetPos = ClientConfigs.getConfig().getOverlayConfig(target).getPosNoAnchor();
            x += anchorTargetPos.x;
            y += anchorTargetPos.y;
        }
        PointData pos = new PointData(x += ((Integer)this.X_OFFSET.get()).intValue(), y += ((Integer)this.Y_OFFSET.get()).intValue());
        return pos;
    }

    public PointData getPosNoAnchor() {
        OverlayType target = (OverlayType)((Object)this.ANCHOR_TARGET.get());
        int x = ((OverlayAnchor.AttachmentPosition)((Object)this.ANCHOR_X.get())).getAnchorPos((OverlayType)target).x;
        int y = ((OverlayAnchor.AttachmentPosition)((Object)this.ANCHOR_Y.get())).getAnchorPos((OverlayType)target).y;
        PointData pos = new PointData(x += ((Integer)this.X_OFFSET.get()).intValue(), y += ((Integer)this.Y_OFFSET.get()).intValue());
        return pos;
    }
}

