/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.characters;

import com.robertx22.mine_and_slash.database.data.stats.types.resources.blood.Blood;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.energy.Energy;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.health.Health;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.mana.Mana;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.stats.StatFormatter;
import net.minecraft.stats.Stats;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class PlayerStats {
    public static final ResourceLocation LEVELS_GAINED = new ResourceLocation("mmorpg", "levels_gained");
    public static final HashMap<String, ResourceLocation> REGISTERED_STATS = new HashMap();
    private static final Map<String, Registrations> registrations = new ConcurrentHashMap<String, Registrations>();

    public static void registerCustomStat(ResourceLocation identifier) {
        PlayerStats.getActiveRegistrations().customStats.add(identifier);
    }

    public static void register() {
        FMLJavaModLoadingContext.get().getModEventBus().register((Object)PlayerStats.getActiveRegistrations());
    }

    private static Registrations getActiveRegistrations() {
        return registrations.computeIfAbsent(ModLoadingContext.get().getActiveNamespace(), it -> new Registrations());
    }

    public static void addReg(String id) {
        REGISTERED_STATS.put(id, new ResourceLocation("mmorpg", id));
    }

    public static void initialize() {
        PlayerStats.addReg(Health.getInstance().GUID());
        PlayerStats.addReg(Mana.getInstance().GUID());
        PlayerStats.addReg(Blood.getInstance().GUID());
        PlayerStats.addReg(Energy.getInstance().GUID());
        PlayerStats.addReg(MagicShield.getInstance().GUID());
        PlayerStats.registerCustomStat(LEVELS_GAINED);
        for (ResourceLocation rl : REGISTERED_STATS.values()) {
            PlayerStats.registerCustomStat(rl);
        }
    }

    private static class Registrations {
        public final List<ResourceLocation> customStats = new ArrayList<ResourceLocation>();

        private Registrations() {
        }

        @SubscribeEvent
        public void commonSetup(FMLCommonSetupEvent event) {
            event.enqueueWork(() -> this.customStats.forEach(it -> {
                Registry.m_122961_((Registry)BuiltInRegistries.f_256771_, (String)it.m_135815_(), (Object)it);
                Stats.f_12988_.m_12899_(it, StatFormatter.f_12873_);
            }));
        }
    }
}

